/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.slf4j.Logger;

public interface ListOperation {
    public static final MapCodec<ListOperation> UNLIMITED_CODEC = ListOperation.codec(Integer.MAX_VALUE);

    public static MapCodec<ListOperation> codec(int maxSize) {
        return Type.CODEC.dispatchMap("mode", ListOperation::mode, type -> type.mapCodec).validate(listOperation -> {
            int i;
            ReplaceSection replaceSection;
            if (listOperation instanceof ReplaceSection && (replaceSection = (ReplaceSection)listOperation).size().isPresent() && (i = replaceSection.size().get().intValue()) > maxSize) {
                return DataResult.error(() -> "Size value too large: " + i + ", max size is " + maxSize);
            }
            return DataResult.success((Object)listOperation);
        });
    }

    public Type mode();

    default public <T> List<T> apply(List<T> currentValue, List<T> operand) {
        return this.apply(currentValue, operand, Integer.MAX_VALUE);
    }

    public <T> List<T> apply(List<T> var1, List<T> var2, int var3);

    public static enum Type implements StringRepresentable
    {
        REPLACE_ALL("replace_all", ReplaceAll.MAP_CODEC),
        REPLACE_SECTION("replace_section", ReplaceSection.MAP_CODEC),
        INSERT("insert", Insert.MAP_CODEC),
        APPEND("append", Append.MAP_CODEC);

        public static final Codec<Type> CODEC;
        private final String id;
        final MapCodec<? extends ListOperation> mapCodec;

        private Type(String id, MapCodec<? extends ListOperation> mapCodec) {
            this.id = id;
            this.mapCodec = mapCodec;
        }

        public MapCodec<? extends ListOperation> mapCodec() {
            return this.mapCodec;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public record ReplaceSection(int offset, Optional<Integer> size) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<ReplaceSection> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(ReplaceSection::offset), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("size").forGetter(ReplaceSection::size)).apply((Applicative)instance, ReplaceSection::new));

        public ReplaceSection(int offset) {
            this(offset, Optional.empty());
        }

        @Override
        public Type mode() {
            return Type.REPLACE_SECTION;
        }

        @Override
        public <T> List<T> apply(List<T> currentValue, List<T> operand, int maxSize) {
            ImmutableList list;
            int size = currentValue.size();
            if (this.offset > size) {
                LOGGER.error("Cannot replace when offset is out of bounds");
                return currentValue;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(currentValue.subList(0, this.offset));
            builder.addAll(operand);
            int i = this.offset + this.size.orElse(operand.size());
            if (i < size) {
                builder.addAll(currentValue.subList(i, size));
            }
            if ((list = builder.build()).size() > maxSize) {
                LOGGER.error("Contents overflow in section replacement");
                return currentValue;
            }
            return list;
        }
    }

    public record StandAlone<T>(List<T> value, ListOperation operation) {
        public static <T> Codec<StandAlone<T>> codec(Codec<T> elementCodec, int maxSize) {
            return RecordCodecBuilder.create(instance -> instance.group((App)elementCodec.sizeLimitedListOf(maxSize).fieldOf("values").forGetter(standAlone -> standAlone.value), (App)ListOperation.codec(maxSize).forGetter(standAlone -> standAlone.operation)).apply((Applicative)instance, StandAlone::new));
        }

        public List<T> apply(List<T> list) {
            return this.operation.apply(list, this.value);
        }
    }

    public static class ReplaceAll
    implements ListOperation {
        public static final ReplaceAll INSTANCE = new ReplaceAll();
        public static final MapCodec<ReplaceAll> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private ReplaceAll() {
        }

        @Override
        public Type mode() {
            return Type.REPLACE_ALL;
        }

        @Override
        public <T> List<T> apply(List<T> currentValue, List<T> operand, int maxSize) {
            return operand;
        }
    }

    public record Insert(int offset) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<Insert> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(Insert::offset)).apply((Applicative)instance, Insert::new));

        @Override
        public Type mode() {
            return Type.INSERT;
        }

        @Override
        public <T> List<T> apply(List<T> currentValue, List<T> operand, int maxSize) {
            int size = currentValue.size();
            if (this.offset > size) {
                LOGGER.error("Cannot insert when offset is out of bounds");
                return currentValue;
            }
            if (size + operand.size() > maxSize) {
                LOGGER.error("Contents overflow in section insertion");
                return currentValue;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(currentValue.subList(0, this.offset));
            builder.addAll(operand);
            builder.addAll(currentValue.subList(this.offset, size));
            return builder.build();
        }
    }

    public static class Append
    implements ListOperation {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final Append INSTANCE = new Append();
        public static final MapCodec<Append> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private Append() {
        }

        @Override
        public Type mode() {
            return Type.APPEND;
        }

        @Override
        public <T> List<T> apply(List<T> currentValue, List<T> operand, int maxSize) {
            if (currentValue.size() + operand.size() > maxSize) {
                LOGGER.error("Contents overflow in section append");
                return currentValue;
            }
            return Stream.concat(currentValue.stream(), operand.stream()).toList();
        }
    }
}

