/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.UnsignedLong;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.timers.TimerCallback;
import net.minecraft.world.level.timers.TimerCallbacks;
import org.slf4j.Logger;

public class TimerQueue<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CALLBACK_DATA_TAG = "Callback";
    private static final String TIMER_NAME_TAG = "Name";
    private static final String TIMER_TRIGGER_TIME_TAG = "TriggerTime";
    private final TimerCallbacks<T> callbacksRegistry;
    private final Queue<Event<T>> queue = new PriorityQueue<Event<T>>(TimerQueue.createComparator());
    private UnsignedLong sequentialId = UnsignedLong.ZERO;
    private final Table<String, Long, Event<T>> events = HashBasedTable.create();

    private static <T> Comparator<Event<T>> createComparator() {
        return Comparator.comparingLong(event -> event.triggerTime).thenComparing(event -> event.sequentialId);
    }

    public TimerQueue(TimerCallbacks<T> callbacksRegistry, Stream<? extends Dynamic<?>> scheduledEventsDynamic) {
        this(callbacksRegistry);
        this.queue.clear();
        this.events.clear();
        this.sequentialId = UnsignedLong.ZERO;
        scheduledEventsDynamic.forEach(scheduledEventDynamic -> {
            Tag tag = scheduledEventDynamic.convert(NbtOps.INSTANCE).getValue();
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                this.loadEvent(compoundTag);
            } else {
                LOGGER.warn("Invalid format of events: {}", (Object)tag);
            }
        });
    }

    public TimerQueue(TimerCallbacks<T> callbacksRegistry) {
        this.callbacksRegistry = callbacksRegistry;
    }

    public void tick(T obj, long gameTime) {
        Event<T> event;
        while ((event = this.queue.peek()) != null && event.triggerTime <= gameTime) {
            this.queue.remove();
            this.events.remove((Object)event.id, (Object)gameTime);
            event.callback.handle(obj, this, gameTime);
        }
        return;
    }

    public void schedule(String id, long triggerTime, TimerCallback<T> callback) {
        if (!this.events.contains((Object)id, (Object)triggerTime)) {
            this.sequentialId = this.sequentialId.plus(UnsignedLong.ONE);
            Event<T> event = new Event<T>(triggerTime, this.sequentialId, id, callback);
            this.events.put((Object)id, (Object)triggerTime, event);
            this.queue.add(event);
        }
    }

    public int remove(String eventId) {
        Collection collection = this.events.row((Object)eventId).values();
        collection.forEach(this.queue::remove);
        int size = collection.size();
        collection.clear();
        return size;
    }

    public Set<String> getEventsIds() {
        return Collections.unmodifiableSet(this.events.rowKeySet());
    }

    private void loadEvent(CompoundTag tag) {
        TimerCallback timerCallback = tag.read(CALLBACK_DATA_TAG, this.callbacksRegistry.codec()).orElse(null);
        if (timerCallback != null) {
            String stringOr = tag.getStringOr(TIMER_NAME_TAG, "");
            long longOr = tag.getLongOr(TIMER_TRIGGER_TIME_TAG, 0L);
            this.schedule(stringOr, longOr, timerCallback);
        }
    }

    private CompoundTag storeEvent(Event<T> event) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString(TIMER_NAME_TAG, event.id);
        compoundTag.putLong(TIMER_TRIGGER_TIME_TAG, event.triggerTime);
        compoundTag.store(CALLBACK_DATA_TAG, this.callbacksRegistry.codec(), event.callback);
        return compoundTag;
    }

    public ListTag store() {
        ListTag listTag = new ListTag();
        this.queue.stream().sorted(TimerQueue.createComparator()).map(this::storeEvent).forEach(listTag::add);
        return listTag;
    }

    public static class Event<T> {
        public final long triggerTime;
        public final UnsignedLong sequentialId;
        public final String id;
        public final TimerCallback<T> callback;

        Event(long triggerTime, UnsignedLong sequentialId, String id, TimerCallback<T> callback) {
            this.triggerTime = triggerTime;
            this.sequentialId = sequentialId;
            this.id = id;
            this.callback = callback;
        }
    }
}

