/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.persistence.PaperPersistentDataContainerView;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Optionull;
import net.minecraft.Util;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftStatistic;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@SerializableAs(value="Player")
public class CraftOfflinePlayer
implements OfflinePlayer,
ConfigurationSerializable {
    private final NameAndId nameAndId;
    private final CraftServer server;
    private final PlayerDataStorage storage;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private @MonotonicNonNull PersistentDataContainerView persistentDataContainerView;

    protected CraftOfflinePlayer(CraftServer server, NameAndId nameAndId) {
        this.server = server;
        this.nameAndId = nameAndId;
        this.storage = server.console.playerDataStorage;
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public boolean isConnected() {
        return false;
    }

    public String getName() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getName();
        }
        if (!this.nameAndId.name().isEmpty()) {
            return this.nameAndId.name();
        }
        CompoundTag data = this.getBukkitData();
        if (data != null) {
            return data.getString("lastKnownName").orElse(null);
        }
        return null;
    }

    public UUID getUniqueId() {
        return this.nameAndId.id();
    }

    public PlayerProfile getPlayerProfile() {
        return CraftPlayerProfile.asBukkitCopy(this.nameAndId.toUncompletedGameProfile());
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isOp() {
        return this.server.getHandle().isOp(this.nameAndId);
    }

    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().op(this.nameAndId);
        } else {
            this.server.getHandle().deop(this.nameAndId);
        }
    }

    public boolean isBanned() {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).isBanned((Object)this.getPlayerProfile());
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant expires, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan((Object)this.getPlayerProfile(), reason, expires, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan((Object)this.getPlayerProfile(), reason, duration, source);
    }

    public void setBanned(boolean value) {
        if (value) {
            ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), null, (Date)null, null);
        } else {
            ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).pardon((Object)this.getPlayerProfile());
        }
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().getWhiteList().isWhiteListed(this.nameAndId);
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().getWhiteList().add(new UserWhiteListEntry(this.nameAndId));
        } else {
            this.server.getHandle().getWhiteList().remove(this.nameAndId);
        }
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("UUID", this.nameAndId.id().toString());
        return result;
    }

    public static OfflinePlayer deserialize(Map<String, Object> args) {
        if (args.get("name") != null) {
            return Bukkit.getServer().getOfflinePlayer((String)args.get("name"));
        }
        return Bukkit.getServer().getOfflinePlayer(UUID.fromString((String)args.get("UUID")));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[UUID=" + String.valueOf(this.nameAndId.id()) + "]";
    }

    public Player getPlayer() {
        return this.server.getPlayer(this.getUniqueId());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        return this.getUniqueId().equals(other.getUniqueId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.getUniqueId().hashCode();
        return hash;
    }

    private CompoundTag getData() {
        return this.storage.load(this.nameAndId).orElse(null);
    }

    private CompoundTag getBukkitData() {
        CompoundTag result = this.getData();
        if (result != null) {
            result = result.getCompound("bukkit").orElse(null);
        }
        return result;
    }

    private File getDataFile() {
        return new File(this.storage.getPlayerDir(), String.valueOf(this.getUniqueId()) + ".dat");
    }

    public long getFirstPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getFirstPlayed();
        }
        CompoundTag data = this.getBukkitData();
        if (data != null) {
            return data.getLong("firstPlayed").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public long getLastPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastPlayed();
        }
        CompoundTag data = this.getBukkitData();
        if (data != null) {
            return data.getLong("lastPlayed").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public boolean hasPlayedBefore() {
        return this.getData() != null;
    }

    public long getLastLogin() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastLogin();
        }
        CompoundTag data = this.getPaperData();
        if (data != null) {
            return data.getLong("LastLogin").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public long getLastSeen() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastSeen();
        }
        CompoundTag data = this.getPaperData();
        if (data != null) {
            return data.getLong("LastSeen").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    private CompoundTag getPaperData() {
        CompoundTag result = this.getData();
        if (result != null) {
            result = result.getCompound("Paper").orElse(null);
        }
        return result;
    }

    public PersistentDataContainerView getPersistentDataContainer() {
        if (this.persistentDataContainerView == null) {
            this.persistentDataContainerView = new PaperPersistentDataContainerView(DATA_TYPE_REGISTRY){

                private CompoundTag getPersistentTag() {
                    return Optionull.map(CraftOfflinePlayer.this.getData(), data -> data.getCompound("BukkitValues").orElse(null));
                }

                @Override
                public CompoundTag toTagCompound() {
                    return Objects.requireNonNullElseGet(this.getPersistentTag(), CompoundTag::new);
                }

                @Override
                public Tag getTag(String key) {
                    return Optionull.map(this.getPersistentTag(), tag -> tag.get(key));
                }

                public int getSize() {
                    return this.getPersistentTag().size();
                }
            };
        }
        return this.persistentDataContainerView;
    }

    public Location getLastDeathLocation() {
        CompoundTag data = this.getData();
        if (data == null) {
            return null;
        }
        return data.read("LastDeathLocation", GlobalPos.CODEC).map(CraftLocation::fromGlobalPos).orElse(null);
    }

    public Location getLocation() {
        if (this.isOnline()) {
            return this.getPlayer().getLocation();
        }
        CompoundTag data = this.getData();
        if (data == null) {
            return null;
        }
        Vec3 pos = data.read("Pos", Vec3.CODEC).orElse(null);
        Vec2 rot = data.read("Rotation", Vec2.CODEC).orElse(null);
        if (pos != null && rot != null) {
            Long msb = data.getLong("WorldUUIDMost").orElse(null);
            Long lsb = data.getLong("WorldUUIDLeast").orElse(null);
            World world = msb != null && lsb != null ? this.server.getWorld(new UUID(msb, lsb)) : null;
            return new Location(world, pos.x(), pos.y(), pos.z(), rot.x, rot.y);
        }
        return null;
    }

    public Location getRespawnLocation(boolean loadLocationAndValidate) {
        CompoundTag data = this.getData();
        if (data == null) {
            return null;
        }
        ServerPlayer.RespawnConfig respawnConfig = data.read("respawn", ServerPlayer.RespawnConfig.CODEC).orElse(null);
        if (respawnConfig == null) {
            return null;
        }
        ServerLevel level = this.server.console.getLevel(respawnConfig.respawnData().dimension());
        if (level == null) {
            return null;
        }
        if (!loadLocationAndValidate) {
            return CraftLocation.toBukkit((Vec3i)respawnConfig.respawnData().pos(), (Level)level, respawnConfig.respawnData().yaw(), respawnConfig.respawnData().pitch());
        }
        return ServerPlayer.findRespawnAndUseSpawnBlock(level, respawnConfig, false).map(resolvedPos -> CraftLocation.toBukkit(resolvedPos.position(), (Level)level, resolvedPos.yaw(), resolvedPos.pitch())).orElse(null);
    }

    private ServerStatsCounter getStatisticManager() {
        return this.server.getHandle().getPlayerStats(this.getUniqueId(), this.getName());
    }

    public void incrementStatistic(Statistic statistic) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, null);
            manager.save();
        }
    }

    public void decrementStatistic(Statistic statistic) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, null);
            manager.save();
        }
    }

    public int getStatistic(Statistic statistic) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, amount);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, amount, null);
            manager.save();
        }
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, amount);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, amount, null);
            manager.save();
        }
    }

    public void setStatistic(Statistic statistic, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, newValue);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, newValue, null);
            manager.save();
        }
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, material);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, material, null);
            manager.save();
        }
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, material);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, material, null);
            manager.save();
        }
    }

    public int getStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic, material);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, material, amount);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, material, amount, null);
            manager.save();
        }
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, material, amount);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, material, amount, null);
            manager.save();
        }
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, material, newValue);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, material, newValue, null);
            manager.save();
        }
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, entityType);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, entityType, null);
            manager.save();
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, entityType);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, entityType, null);
            manager.save();
        }
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic, entityType);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, entityType, amount);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, entityType, amount, null);
            manager.save();
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, entityType, amount);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, entityType, amount, null);
            manager.save();
        }
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, entityType, newValue);
        } else {
            ServerStatsCounter manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, entityType, newValue, null);
            manager.save();
        }
    }

    public boolean getAllowFlight() {
        if (this.isOnline()) {
            return this.getPlayer().getAllowFlight();
        }
        CompoundTag data = this.getData();
        if (data == null) {
            return false;
        }
        Tag tag = data.get("abilities");
        if (!(tag instanceof CompoundTag)) {
            return false;
        }
        CompoundTag abilities = (CompoundTag)tag;
        return abilities.getByteOr("mayfly", (byte)0) == 1;
    }

    public void setAllowFlight(boolean flight) {
        if (this.isOnline()) {
            this.getPlayer().setAllowFlight(flight);
        } else {
            CompoundTag data = this.getData();
            if (data == null) {
                return;
            }
            Tag tag = data.get("abilities");
            if (!(tag instanceof CompoundTag)) {
                return;
            }
            CompoundTag abilities = (CompoundTag)tag;
            abilities.putByte("mayfly", (byte)(flight ? 1 : 0));
            data.put("abilities", abilities);
            this.save(data);
        }
    }

    public boolean isFlying() {
        if (this.isOnline()) {
            return this.isFlying();
        }
        CompoundTag data = this.getData();
        if (data == null) {
            return false;
        }
        Tag tag = data.get("abilities");
        if (!(tag instanceof CompoundTag)) {
            return false;
        }
        CompoundTag abilities = (CompoundTag)tag;
        return abilities.getByteOr("flying", (byte)0) == 1;
    }

    public void setFlying(boolean value) {
        if (this.isOnline()) {
            this.getPlayer().setFlying(value);
        } else {
            CompoundTag data = this.getData();
            if (data == null) {
                return;
            }
            Tag tag = data.get("abilities");
            if (!(tag instanceof CompoundTag)) {
                return;
            }
            CompoundTag abilities = (CompoundTag)tag;
            abilities.putByte("mayfly", (byte)(value ? 1 : 0));
            data.put("abilities", abilities);
            this.save(data);
        }
    }

    public void setFlySpeed(float value) throws IllegalArgumentException {
        if (value < -1.0f || value > 1.0f) {
            throw new IllegalArgumentException("FlySpeed needs to be between -1 and 1");
        }
        if (this.isOnline()) {
            this.getPlayer().setFlySpeed(value);
        } else {
            CompoundTag data = this.getData();
            if (data == null) {
                return;
            }
            Tag tag = data.get("abilities");
            if (!(tag instanceof CompoundTag)) {
                return;
            }
            CompoundTag abilities = (CompoundTag)tag;
            abilities.putFloat("flySpeed", value);
            data.put("abilities", abilities);
            this.save(data);
        }
    }

    public float getFlySpeed() {
        if (this.isOnline()) {
            return this.getPlayer().getFlySpeed();
        }
        CompoundTag data = this.getData();
        if (data == null) {
            return 0.0f;
        }
        Tag tag = data.get("abilities");
        if (!(tag instanceof CompoundTag)) {
            return 0.0f;
        }
        CompoundTag abilities = (CompoundTag)tag;
        return abilities.getFloatOr("flySpeed", 0.0f);
    }

    public void setWalkSpeed(float value) throws IllegalArgumentException {
        if (value < -1.0f || value > 1.0f) {
            throw new IllegalArgumentException("WalkSpeed needs to be between -1 and 1");
        }
        if (this.isOnline()) {
            this.getPlayer().setWalkSpeed(value);
        } else {
            CompoundTag data = this.getData();
            if (data == null) {
                return;
            }
            Tag tag = data.get("abilities");
            if (!(tag instanceof CompoundTag)) {
                return;
            }
            CompoundTag abilities = (CompoundTag)tag;
            abilities.putFloat("walkSpeed", value);
            data.put("abilities", abilities);
            this.save(data);
        }
    }

    public float getWalkSpeed() {
        if (this.isOnline()) {
            return this.getPlayer().getWalkSpeed();
        }
        CompoundTag data = this.getData();
        if (data == null) {
            return 0.0f;
        }
        Tag tag = data.get("abilities");
        if (!(tag instanceof CompoundTag)) {
            return 0.0f;
        }
        CompoundTag abilities = (CompoundTag)tag;
        return abilities.getFloatOr("walkSpeed", 0.0f);
    }

    public boolean teleportOffline(Location destination) {
        if (this.isOnline()) {
            return this.getPlayer().teleport(destination);
        }
        return this.setLocation(destination);
    }

    public boolean teleportOffline(Location destination, PlayerTeleportEvent.TeleportCause cause) {
        if (this.isOnline()) {
            return this.getPlayer().teleport(destination, cause);
        }
        return this.setLocation(destination);
    }

    public CompletableFuture<Boolean> teleportOfflineAsync(Location destination) {
        if (this.isOnline()) {
            return this.getPlayer().teleportAsync(destination);
        }
        return CompletableFuture.completedFuture(this.setLocation(destination));
    }

    public CompletableFuture<Boolean> teleportOfflineAsync(Location destination, PlayerTeleportEvent.TeleportCause cause) {
        if (this.isOnline()) {
            return this.getPlayer().teleportAsync(destination, cause);
        }
        return CompletableFuture.completedFuture(this.setLocation(destination));
    }

    private boolean setLocation(Location location) {
        CompoundTag data = this.getData();
        if (data == null) {
            return false;
        }
        data.putLong("WorldUUIDMost", location.getWorld().getUID().getMostSignificantBits());
        data.putLong("WorldUUIDLeast", location.getWorld().getUID().getLeastSignificantBits());
        ListTag position = new ListTag();
        position.add(DoubleTag.valueOf(location.getX()));
        position.add(DoubleTag.valueOf(location.getY()));
        position.add(DoubleTag.valueOf(location.getZ()));
        data.put("Pos", position);
        ListTag rotation = new ListTag();
        rotation.add(FloatTag.valueOf(location.getYaw()));
        rotation.add(FloatTag.valueOf(location.getPitch()));
        data.put("Rotation", rotation);
        this.save(data);
        return true;
    }

    private void save(CompoundTag compoundTag) {
        File playerDir = this.server.console.playerDataStorage.getPlayerDir();
        try {
            File tempFile = File.createTempFile(String.valueOf(this.getUniqueId()) + "-", ".dat", playerDir);
            NbtIo.writeCompressed(compoundTag, tempFile.toPath());
            File playerDataFile = new File(playerDir, String.valueOf(this.getUniqueId()) + ".dat");
            File playerDataFileOld = new File(playerDir, String.valueOf(this.getUniqueId()) + ".dat_old");
            Util.safeReplaceFile(playerDataFile.toPath(), tempFile.toPath(), playerDataFileOld.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

