/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.entry.RegistryTypeMapper;
import io.papermc.paper.registry.set.NamedRegistryKeySetImpl;
import io.papermc.paper.registry.tag.Tag;
import io.papermc.paper.util.Holderable;
import io.papermc.paper.util.MCUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static net.minecraft.core.RegistryAccess registry;
    private final Class<?> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final net.minecraft.core.Registry<M> minecraftRegistry;
    private final RegistryTypeMapper<M, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater;
    private final InvalidHolderOwner invalidHolderOwner = new InvalidHolderOwner(this);
    private boolean lockReferenceHolders;

    public static void setMinecraftRegistry(net.minecraft.core.RegistryAccess registry) {
        Preconditions.checkState((CraftRegistry.registry == null ? 1 : 0) != 0, (Object)"Registry already set");
        CraftRegistry.registry = registry;
    }

    public static net.minecraft.core.RegistryAccess getMinecraftRegistry() {
        return registry;
    }

    public static <E> net.minecraft.core.Registry<E> getMinecraftRegistry(ResourceKey<? extends net.minecraft.core.Registry<E>> key) {
        return CraftRegistry.getMinecraftRegistry().lookupOrThrow(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, ResourceKey<? extends net.minecraft.core.Registry<M>> registryKey) {
        CraftRegistry craftRegistry;
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Registry bukkitRegistry = RegistryAccess.registryAccess().getRegistry(PaperRegistries.registryFromNms(registryKey));
        Optional resourceKey = registry.getResourceKey(minecraft);
        if (resourceKey.isEmpty() && bukkitRegistry instanceof CraftRegistry && (craftRegistry = (CraftRegistry)bukkitRegistry).supportsDirectHolders()) {
            return ((CraftRegistry)bukkitRegistry).createBukkit(Holder.direct(minecraft));
        }
        if (resourceKey.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft));
        }
        Keyed bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(resourceKey.get().location()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> B minecraftHolderToBukkit(Holder<M> minecraft, ResourceKey<? extends net.minecraft.core.Registry<M>> registryKey) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        Registry bukkitRegistry = RegistryAccess.registryAccess().getRegistry(PaperRegistries.registryFromNms(registryKey));
        Holder<M> holder = minecraft;
        Objects.requireNonNull(holder);
        Holder<M> holder2 = holder;
        int n = 0;
        Keyed bukkit = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Holder.Direct.class, Holder.Reference.class}, holder2, n)) {
            case 0 -> {
                CraftRegistry craftRegistry;
                Holder.Direct direct = (Holder.Direct)holder2;
                if (!(bukkitRegistry instanceof CraftRegistry) || !(craftRegistry = (CraftRegistry)bukkitRegistry).supportsDirectHolders()) {
                    throw new IllegalArgumentException("Cannot convert direct holder to bukkit representation");
                }
                yield (Keyed)((CraftRegistry)bukkitRegistry).createBukkit(direct);
            }
            case 1 -> {
                Holder.Reference reference = (Holder.Reference)holder2;
                yield bukkitRegistry.get(MCUtil.fromResourceKey(reference.key()));
            }
            default -> throw new IllegalArgumentException("Unknown holder: " + String.valueOf(minecraft));
        };
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)bukkit).getHandle();
    }

    public static <B extends Keyed, M> Holder<M> bukkitToMinecraftHolder(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Holderable)bukkit).getHolder();
    }

    public static <T extends Keyed, M> Optional<T> unwrapAndConvertHolder(RegistryKey<T> registryKey, Holder<M> value) {
        CraftRegistry craftRegistry;
        Registry registry = RegistryAccess.registryAccess().getRegistry(registryKey);
        if (registry instanceof CraftRegistry && (craftRegistry = (CraftRegistry)registry).supportsDirectHolders() && value.kind() == Holder.Kind.DIRECT) {
            return Optional.of(((CraftRegistry)registry).createBukkit(value));
        }
        return value.unwrapKey().map(key -> registry.get(CraftNamespacedKey.fromMinecraft(key.location())));
    }

    public static <B extends Keyed> B get(RegistryKey<B> bukkitKey, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        Registry bukkit = RegistryAccess.registryAccess().getRegistry(bukkitKey);
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(craft.serializationUpdater.apply(namespacedKey, apiVersion));
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == EntityType.class) {
                return (B)bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return (B)bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return (B)bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<?> bukkitClass, net.minecraft.core.Registry<M> minecraftRegistry, BiFunction<? super NamespacedKey, M, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater) {
        this(bukkitClass, minecraftRegistry, new RegistryTypeMapper<M, B>(minecraftToBukkit), serializationUpdater);
    }

    public CraftRegistry(RegistryEntryMeta.ServerSide<M, B> meta, net.minecraft.core.Registry<M> minecraftRegistry) {
        this(meta.classToPreload(), minecraftRegistry, meta.registryTypeMapper(), meta.serializationUpdater());
    }

    public CraftRegistry(Class<?> bukkitClass, net.minecraft.core.Registry<M> minecraftRegistry, RegistryTypeMapper<M, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.serializationUpdater = serializationUpdater;
        this.lockReferenceHolders = !this.minecraftToBukkit.constructorUsesHolder();
    }

    public void lockReferenceHolders() {
        Preconditions.checkState((boolean)this.cache.isEmpty(), (String)"Registry %s is already loaded", this.minecraftRegistry.key());
        try {
            Class.forName(this.bukkitClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load class " + this.bukkitClass.getSimpleName(), e);
        }
        if (!this.minecraftToBukkit.constructorUsesHolder()) {
            return;
        }
        Preconditions.checkState((!this.lockReferenceHolders ? 1 : 0) != 0, (Object)"Reference holders are already locked");
        this.lockReferenceHolders = true;
    }

    public B get(NamespacedKey namespacedKey) {
        Holder.Reference<M> holder;
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        Optional holderOptional = this.minecraftRegistry.get(MCUtil.toResourceKey(this.minecraftRegistry.key(), namespacedKey));
        if (holderOptional.isPresent()) {
            holder = (Holder.Reference<M>)holderOptional.get();
        } else if (!this.lockReferenceHolders && this.minecraftToBukkit.constructorUsesHolder()) {
            holder = Holder.Reference.createStandAlone(this.invalidHolderOwner, MCUtil.toResourceKey(this.minecraftRegistry.key(), namespacedKey));
        } else {
            return null;
        }
        B bukkit = this.createBukkit(holder);
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.keySet().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    @NotNull
    public Stream<NamespacedKey> keyStream() {
        return this.minecraftRegistry.keySet().stream().map(CraftNamespacedKey::fromMinecraft);
    }

    public int size() {
        return this.minecraftRegistry.size();
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(Holder<M> minecraft) {
        return (B)((Keyed)this.minecraftToBukkit.createBukkit(minecraft));
    }

    public boolean supportsDirectHolders() {
        return this.minecraftToBukkit.supportsDirectHolders();
    }

    public NamespacedKey getKey(B value) {
        if (value instanceof Holderable) {
            Holderable holderable = (Holderable)value;
            return holderable.getKeyOrNull();
        }
        return value.getKey();
    }

    public boolean hasTag(io.papermc.paper.registry.tag.TagKey<B> key) {
        return this.minecraftRegistry.get(TagKey.create(this.minecraftRegistry.key(), PaperAdventure.asVanilla(key.key()))).isPresent();
    }

    public Tag<B> getTag(io.papermc.paper.registry.tag.TagKey<B> key) {
        HolderSet.Named namedHolderSet = (HolderSet.Named)this.minecraftRegistry.get(PaperRegistries.toNms(key)).orElseThrow();
        return new NamedRegistryKeySetImpl(key, namedHolderSet);
    }

    public Collection<Tag<B>> getTags() {
        return this.minecraftRegistry.getTags().map(NamedRegistryKeySetImpl::new).toList();
    }

    final class InvalidHolderOwner
    implements HolderOwner<M> {
        InvalidHolderOwner(CraftRegistry this$0) {
        }
    }
}

