/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.FeatureHooks;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.math.Position;
import io.papermc.paper.raytracing.PositionedRayTraceConfigurationBuilder;
import io.papermc.paper.raytracing.PositionedRayTraceConfigurationBuilderImpl;
import io.papermc.paper.raytracing.RayTraceTarget;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.StackWalkerUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.pointer.PointersSupplier;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Color;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftEffect;
import org.bukkit.craftbukkit.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.CraftHeightMap;
import org.bukkit.craftbukkit.CraftParticle;
import org.bukkit.craftbukkit.CraftRaid;
import org.bukkit.craftbukkit.CraftRegionAccessor;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.CraftWorldBorder;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.generator.structure.CraftGeneratedStructure;
import org.bukkit.craftbukkit.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftBiomeSearchResult;
import org.bukkit.craftbukkit.util.CraftDifficulty;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.util.CraftStructureSearchResult;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BiomeSearchResult;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.AsyncCatcher;

public class CraftWorld
extends CraftRegionAccessor
implements World {
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private static final PointersSupplier<World> POINTERS_SUPPLIER = (PointersSupplier)PointersSupplier.builder().resolving(Identity.NAME, WorldInfo::getName).resolving(Identity.UUID, WorldInfo::getUID).build();
    private final ServerLevel world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    @Nullable
    private final org.bukkit.generator.ChunkGenerator generator;
    @Nullable
    private final BiomeProvider biomeProvider;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private boolean voidDamageEnabled;
    private float voidDamageAmount;
    private double voidDamageMinBuildHeightOffset;
    private static final Random rand = new Random();
    private Map<String, GameRules.Key<?>> gamerules;
    private Map<String, GameRules.Type<?>> gameruleDefinitions;
    private final World.Spigot spigot = new World.Spigot(){

        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            return CraftWorld.this.strikeLightning(loc);
        }

        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            return CraftWorld.this.strikeLightningEffect(loc);
        }
    };

    public boolean isVoidDamageEnabled() {
        return this.voidDamageEnabled;
    }

    public void setVoidDamageEnabled(boolean enabled) {
        this.voidDamageEnabled = enabled;
    }

    public float getVoidDamageAmount() {
        return this.voidDamageAmount;
    }

    public void setVoidDamageAmount(float voidDamageAmount) {
        this.voidDamageAmount = voidDamageAmount;
    }

    public double getVoidDamageMinBuildHeightOffset() {
        return this.voidDamageMinBuildHeightOffset;
    }

    public void setVoidDamageMinBuildHeightOffset(double minBuildHeightOffset) {
        this.voidDamageMinBuildHeightOffset = minBuildHeightOffset;
    }

    public int getEntityCount() {
        int ret = 0;
        for (net.minecraft.world.entity.Entity entity : this.world.getEntities().getAll()) {
            if (!entity.getBukkitEntity().isValid()) continue;
            ++ret;
        }
        return ret;
    }

    public int getTileEntityCount() {
        int size = 0;
        for (ChunkHolder playerchunk : PlatformHooks.get().getVisibleChunkHolders(this.world)) {
            LevelChunk chunk = playerchunk.getTickingChunk();
            if (chunk == null) continue;
            size += chunk.blockEntities.size();
        }
        return size;
    }

    public int getTickableTileEntityCount() {
        return this.world.blockEntityTickers.size();
    }

    public int getChunkCount() {
        return this.world.getChunkSource().getFullChunksCount();
    }

    public int getPlayerCount() {
        return this.world.players().size();
    }

    public BiomeProvider vanillaBiomeProvider() {
        BiomeSource biomeSource;
        ServerChunkCache serverCache = this.getHandle().chunkSource;
        ChunkGenerator gen = serverCache.getGenerator();
        if (gen instanceof CustomChunkGenerator) {
            CustomChunkGenerator custom = (CustomChunkGenerator)gen;
            biomeSource = custom.getDelegate().getBiomeSource();
        } else {
            biomeSource = gen.getBiomeSource();
        }
        if (biomeSource instanceof CustomWorldChunkManager) {
            CustomWorldChunkManager customBiomeSource = (CustomWorldChunkManager)biomeSource;
            biomeSource = customBiomeSource.vanillaBiomeSource;
        }
        final BiomeSource finalBiomeSource = biomeSource;
        final Climate.Sampler sampler = serverCache.randomState().sampler();
        final List<org.bukkit.block.Biome> possibleBiomes = finalBiomeSource.possibleBiomes().stream().map(CraftBiome::minecraftHolderToBukkit).toList();
        return new BiomeProvider(this){

            public org.bukkit.block.Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
                return CraftBiome.minecraftHolderToBukkit(finalBiomeSource.getNoiseBiome(x >> 2, y >> 2, z >> 2, sampler));
            }

            public List<org.bukkit.block.Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }

    public boolean hasStructureAt(Position position, Structure structure) {
        return this.world.structureManager().getStructureWithPieceAt(MCUtil.toBlockPos(position), CraftStructure.bukkitToMinecraft(structure)).isValid();
    }

    public CraftWorld(ServerLevel world, @Nullable org.bukkit.generator.ChunkGenerator generator, @Nullable BiomeProvider biomeProvider, World.Environment environment) {
        this.world = world;
        this.generator = generator;
        this.biomeProvider = biomeProvider;
        this.environment = environment;
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.setSpawnLimit(spawnCategory, this.world.paperConfig().entities.spawning.spawnLimits.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory)));
        }
        this.voidDamageEnabled = this.world.paperConfig().environment.voidDamageAmount.enabled();
        this.voidDamageMinBuildHeightOffset = this.world.paperConfig().environment.voidDamageMinBuildHeightOffset;
        this.voidDamageAmount = (float)this.world.paperConfig().environment.voidDamageAmount.or(0.0);
    }

    public org.bukkit.block.Block getBlockAt(int x, int y, int z) {
        return CraftBlock.at(this.world, new BlockPos(x, y, z));
    }

    public Location getSpawnLocation() {
        LevelData.RespawnData respawnData = this.world.serverLevelData.getRespawnData();
        return CraftLocation.toBukkit((Vec3i)respawnData.pos(), (World)this, respawnData.yaw(), respawnData.pitch());
    }

    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw(), location.getPitch()) : false;
    }

    private boolean setSpawnLocation(int x, int y, int z, float yaw, float pitch) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.world.serverLevelData.setSpawn(new LevelData.RespawnData(GlobalPos.of(ResourceKey.create(Registries.DIMENSION, this.world.dimension().location()), new BlockPos(x, y, z)), Mth.wrapDegrees(yaw), Mth.wrapDegrees(pitch)));
            this.server.getServer().updateEffectiveRespawnData();
            new SpawnChangeEvent((World)this, previousLocation).callEvent();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setSpawnLocation(int x, int y, int z, float yaw) {
        return this.setSpawnLocation(x, y, z, yaw, 0.0f);
    }

    private static void warnUnsafeChunk(String reason, int x, int z) {
        int max = 1875625;
        if (x > max || z > max || x < -max || z < -max) {
            JavaPlugin plugin = StackWalkerUtil.getFirstPluginCaller();
            if (plugin != null) {
                plugin.getLogger().warning("Plugin is %s at (%s, %s), this might cause issues.".formatted(reason, x, z));
            }
            if (MinecraftServer.getServer().isDebugging()) {
                TraceUtil.dumpTraceForThread("Dangerous chunk retrieval");
            }
        }
    }

    public Chunk getChunkAt(int x, int z) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk", x, z);
        LevelChunk chunk = (LevelChunk)this.world.getChunk(x, z, ChunkStatus.FULL, true);
        return new CraftChunk(chunk);
    }

    @NotNull
    public Chunk getChunkAt(int x, int z, boolean generate) {
        if (generate) {
            return this.getChunkAt(x, z);
        }
        return new CraftChunk(this.getHandle(), x, z);
    }

    public Chunk getChunkAt(org.bukkit.block.Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"null block");
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.world.getChunkSource().isChunkLoaded(x, z);
    }

    public boolean isChunkGenerated(int x, int z) {
        if (!Bukkit.isPrimaryThread()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x, z), this.world.getChunkSource().mainThreadProcessor).join();
        }
        ChunkAccess chunk = this.world.getChunkSource().getChunkAtImmediately(x, z);
        if (chunk != null) {
            return chunk instanceof ImposterProtoChunk || chunk instanceof LevelChunk;
        }
        CompletableFuture future = new CompletableFuture();
        PlatformHooks.get().scheduleChunkLoad(this.world, x, z, false, ChunkStatus.EMPTY, true, Priority.NORMAL, future::complete);
        this.world.getChunkSource().mainThreadProcessor.managedBlock(future::isDone);
        return (Boolean)((CompletableFuture)future.thenApply(c -> {
            if (c != null) {
                return c.getPersistedStatus() == ChunkStatus.FULL;
            }
            return false;
        })).join();
    }

    public Chunk[] getLoadedChunks() {
        int size;
        ServerChunkCache serverChunkCache = this.getHandle().chunkSource;
        ReferenceList<Chunk> chunks = new ReferenceList<Chunk>(new Chunk[serverChunkCache.fullChunks.size()]);
        PrimitiveIterator.OfLong iterator = serverChunkCache.fullChunks.keyIterator();
        while (iterator.hasNext()) {
            long chunk = iterator.nextLong();
            chunks.add(new CraftChunk(this.world, CoordinateUtils.getChunkX(chunk), CoordinateUtils.getChunkZ(chunk)));
        }
        Chunk[] raw = chunks.getRawDataUnchecked();
        if (raw.length == (size = chunks.size())) {
            return raw;
        }
        return Arrays.copyOf(raw, size);
    }

    public boolean unloadChunk(int x, int z, boolean save) {
        return this.unloadChunk0(x, z, save);
    }

    public boolean unloadChunkRequest(int x, int z) {
        AsyncCatcher.catchOp("chunk unload");
        if (this.isChunkLoaded(x, z)) {
            this.world.getChunkSource().removeTicketWithRadius(TicketType.PLUGIN, new ChunkPos(x, z), 1);
        }
        return true;
    }

    private boolean unloadChunk0(int x, int z, boolean save) {
        AsyncCatcher.catchOp("chunk unload");
        if (!this.isChunkLoaded(x, z)) {
            return true;
        }
        LevelChunk chunk = this.world.getChunk(x, z);
        if (!save) {
            chunk.tryMarkSaved();
        }
        this.unloadChunkRequest(x, z);
        this.world.getChunkSource().purgeUnload();
        return !this.isChunkLoaded(x, z);
    }

    public boolean refreshChunk(int x, int z) {
        ChunkHolder playerChunk = this.world.getChunkSource().chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong(x, z));
        if (playerChunk == null) {
            return false;
        }
        LevelChunk chunk = playerChunk.getChunkToSend();
        if (chunk == null) {
            return false;
        }
        List<ServerPlayer> playersInRange = playerChunk.playerProvider.getPlayers(playerChunk.getPos(), false);
        if (playersInRange.isEmpty()) {
            return true;
        }
        FeatureHooks.sendChunkRefreshPackets(playersInRange, chunk);
        return true;
    }

    public Collection<org.bukkit.entity.Player> getPlayersSeeingChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"chunk cannot be null");
        return this.getPlayersSeeingChunk(chunk.getX(), chunk.getZ());
    }

    public Collection<org.bukkit.entity.Player> getPlayersSeeingChunk(int x, int z) {
        if (!this.isChunkLoaded(x, z)) {
            return Collections.emptySet();
        }
        List<ServerPlayer> players = this.world.getChunkSource().chunkMap.getPlayers(new ChunkPos(x, z), false);
        if (players.isEmpty()) {
            return Collections.emptySet();
        }
        return players.stream().filter(Objects::nonNull).map(ServerPlayer::getBukkitEntity).collect(Collectors.toUnmodifiableSet());
    }

    public boolean isChunkInUse(int x, int z) {
        return this.isChunkLoaded(x, z);
    }

    public boolean loadChunk(int x, int z, boolean generate) {
        AsyncCatcher.catchOp("chunk load");
        CraftWorld.warnUnsafeChunk("loading a faraway chunk", x, z);
        ChunkAccess chunk = this.world.getChunkSource().getChunk(x, z, generate || this.isChunkGenerated(x, z) ? ChunkStatus.FULL : ChunkStatus.EMPTY, true);
        if (chunk instanceof ImposterProtoChunk) {
            chunk = this.world.getChunkSource().getChunk(x, z, ChunkStatus.FULL, true);
        }
        if (chunk instanceof LevelChunk) {
            this.world.getChunkSource().addTicketWithRadius(TicketType.PLUGIN, new ChunkPos(x, z), 1);
            return true;
        }
        return false;
    }

    public boolean isChunkLoaded(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    public void loadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        this.loadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean addPluginChunkTicket(int x, int z, Plugin plugin) {
        CraftWorld.warnUnsafeChunk("adding a faraway chunk ticket", x, z);
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"null plugin");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"plugin is not enabled");
        ChunkMap.DistanceManager distanceManager = this.world.getChunkSource().chunkMap.distanceManager;
        if (distanceManager.ticketStorage.addPluginRegionTicket(new ChunkPos(x, z), plugin)) {
            this.getChunkAt(x, z);
            return true;
        }
        return false;
    }

    public boolean removePluginChunkTicket(int x, int z, Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        ChunkMap.DistanceManager distanceManager = this.world.getChunkSource().chunkMap.distanceManager;
        return distanceManager.ticketStorage.removePluginRegionTicket(new ChunkPos(x, z), plugin);
    }

    public void removePluginChunkTickets(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        ChunkMap.DistanceManager chunkDistanceManager = this.world.getChunkSource().chunkMap.distanceManager;
        chunkDistanceManager.ticketStorage.removeAllPluginRegionTickets(TicketType.PLUGIN_TICKET, ChunkMap.FORCED_TICKET_LEVEL, plugin);
    }

    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        return FeatureHooks.getPluginChunkTickets(this.world, x, z);
    }

    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        return FeatureHooks.getPluginChunkTickets(this.world);
    }

    @NotNull
    public Collection<Chunk> getIntersectingChunks(@NotNull BoundingBox boundingBox) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int minX = NumberConversions.floor((double)boundingBox.getMinX()) >> 4;
        int maxX = NumberConversions.floor((double)boundingBox.getMaxX()) >> 4;
        int minZ = NumberConversions.floor((double)boundingBox.getMinZ()) >> 4;
        int maxZ = NumberConversions.floor((double)boundingBox.getMaxZ()) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                chunks.add(this.getChunkAt(x, z, false));
            }
        }
        return chunks;
    }

    public boolean isChunkForceLoaded(int x, int z) {
        return this.getHandle().getForceLoadedChunks().contains(ChunkPos.asLong(x, z));
    }

    public void setChunkForceLoaded(int x, int z, boolean forced) {
        CraftWorld.warnUnsafeChunk("forceloading a faraway chunk", x, z);
        this.getHandle().setChunkForced(x, z, forced);
    }

    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<CraftChunk> chunks = new HashSet<CraftChunk>();
        LongIterator longIterator = this.getHandle().getForceLoadedChunks().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(new CraftChunk(this.getHandle(), ChunkPos.getX(coord), ChunkPos.getZ(coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    @Override
    public ServerLevel getHandle() {
        return this.world;
    }

    public Item dropItem(Location location, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        ItemEntity entity = new ItemEntity(this.world, location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy(item));
        Item itemEntity = (Item)entity.getBukkitEntity();
        entity.pickupDelay = 10;
        if (function != null) {
            function.accept((Item)itemEntity);
        }
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return itemEntity;
    }

    public Item dropItemNaturally(Location location, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        double xs = Mth.nextDouble(this.world.random, -0.25, 0.25);
        double ys = Mth.nextDouble(this.world.random, -0.25, 0.25) - (double)EntityType.ITEM.getHeight() / 2.0;
        double zs = Mth.nextDouble(this.world.random, -0.25, 0.25);
        location = location.clone().add(xs, ys, zs);
        return this.dropItem(location, item, function);
    }

    public <T extends AbstractArrow> T spawnArrow(Location location, Vector direction, float speed, float spread, Class<T> clazz) {
        net.minecraft.world.entity.projectile.AbstractArrow arrow;
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz Entity for the arrow cannot be null");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = EntityType.ARROW.create(this.world, EntitySpawnReason.COMMAND);
            ((Arrow)arrow.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (net.minecraft.world.entity.projectile.AbstractArrow)EntityType.SPECTRAL_ARROW.create(this.world, EntitySpawnReason.COMMAND) : (Trident.class.isAssignableFrom(clazz) ? (net.minecraft.world.entity.projectile.AbstractArrow)EntityType.TRIDENT.create(this.world, EntitySpawnReason.COMMAND) : (net.minecraft.world.entity.projectile.AbstractArrow)EntityType.ARROW.create(this.world, EntitySpawnReason.COMMAND));
        }
        arrow.snapTo(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        arrow.shoot(direction.getX(), direction.getY(), direction.getZ(), speed, spread);
        this.world.addFreshEntity(arrow);
        return (T)((AbstractArrow)arrow.getBukkitEntity());
    }

    public LightningStrike strikeLightning(Location loc) {
        return this.strikeLightning0(loc, false);
    }

    public LightningStrike strikeLightningEffect(Location loc) {
        return this.strikeLightning0(loc, true);
    }

    private LightningStrike strikeLightning0(Location loc, boolean isVisual) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        LightningBolt lightning = EntityType.LIGHTNING_BOLT.create(this.world, EntitySpawnReason.COMMAND);
        lightning.snapTo(loc.getX(), loc.getY(), loc.getZ());
        lightning.isEffect = isVisual;
        this.world.strikeLightning(lightning, LightningStrikeEvent.Cause.CUSTOM);
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public Location findLightningRod(Location location) {
        return this.world.findLightningRod(CraftLocation.toBlockPosition(location)).map(blockPos -> CraftLocation.toBukkit((Vec3i)blockPos, (Level)this.world).subtract(0.0, 1.0, 0.0)).orElse(null);
    }

    public Location findLightningTarget(Location location) {
        BlockPos pos = this.world.findLightningTargetAround(CraftLocation.toBlockPosition(location), true);
        return pos == null ? null : CraftLocation.toBukkit((Vec3i)pos, (Level)this.world);
    }

    public boolean generateTree(Location loc, TreeType type) {
        return this.generateTree(loc, rand, type);
    }

    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.captureTreeGeneration = true;
        this.world.captureBlockStates = true;
        boolean grownTree = this.generateTree(loc, type);
        this.world.captureBlockStates = false;
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (org.bukkit.block.BlockState blockState : this.world.capturedBlockStates.values()) {
                BlockPos position = ((CraftBlockState)blockState).getPosition();
                BlockState oldBlock = this.world.getBlockState(position);
                int flags = ((CraftBlockState)blockState).getFlags();
                delegate.setBlockData(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getBlockData());
                BlockState newBlock = this.world.getBlockState(position);
                this.world.notifyAndUpdatePhysics(position, null, oldBlock, newBlock, newBlock, flags, 512);
            }
            this.world.capturedBlockStates.clear();
            return true;
        }
        this.world.capturedBlockStates.clear();
        return false;
    }

    public String getName() {
        return this.world.serverLevelData.getLevelName();
    }

    public UUID getUID() {
        return this.world.uuid;
    }

    @Override
    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.world.dimension().location());
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + "}";
    }

    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    public long getFullTime() {
        return this.world.getDayTime();
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.world.getDayTime());
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.world.setDayTime(this.world.getDayTime() + event.getSkipAmount());
        for (org.bukkit.entity.Player p : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p;
            if (cp.getHandle().connection == null) continue;
            cp.getHandle().connection.send(new ClientboundSetTimePacket(cp.getHandle().level().getGameTime(), cp.getHandle().getPlayerTime(), cp.getHandle().relativeTime && cp.getHandle().level().getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        }
    }

    public boolean isDayTime() {
        return this.getHandle().isBrightOutside();
    }

    public long getGameTime() {
        return this.world.levelData.getGameTime();
    }

    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source) {
        return this.createExplosion(x, y, z, power, setFire, breakBlocks, source, null);
    }

    private boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source, Consumer<ServerExplosion> configurator) {
        Level.ExplosionInteraction explosionType = !breakBlocks ? Level.ExplosionInteraction.NONE : (source == null ? Level.ExplosionInteraction.STANDARD : Level.ExplosionInteraction.MOB);
        net.minecraft.world.entity.Entity entity = source == null ? null : ((CraftEntity)source).getHandle();
        return !this.world.explode0((net.minecraft.world.entity.Entity)entity, (DamageSource)Explosion.getDefaultDamageSource((Level)this.world, (net.minecraft.world.entity.Entity)entity), null, (double)x, (double)y, (double)z, (float)power, (boolean)setFire, (Level.ExplosionInteraction)explosionType, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, Level.DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEvents.GENERIC_EXPLODE, configurator).wasCanceled;
    }

    public boolean createExplosion(Entity source, Location loc, float power, boolean setFire, boolean breakBlocks, boolean excludeSourceFromDamage) {
        return this.createExplosion(loc.x(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source, e -> {
            e.excludeSourceFromDamage = excludeSourceFromDamage;
        });
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    @NotNull
    public World.Environment getEnvironment() {
        return this.environment;
    }

    @Nullable
    public org.bukkit.generator.ChunkGenerator getGenerator() {
        return this.generator;
    }

    @Nullable
    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @NotNull
    public <T extends LivingEntity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @NotNull CreatureSpawnEvent.SpawnReason spawnReason, boolean randomizeData, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        Preconditions.checkArgument((spawnReason != null ? 1 : 0) != 0, (Object)"Spawn reason cannot be null");
        return (T)((LivingEntity)this.spawn(location, clazz, function, spawnReason, randomizeData));
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk", x >> 4, z >> 4);
        return this.world.getChunk(x >> 4, z >> 4).getHeight(CraftHeightMap.toNMS(heightMap), x, z);
    }

    public void setBiome(int x, int z, org.bukkit.block.Biome bio) {
        for (int y = this.getMinHeight(); y < this.getMaxHeight(); ++y) {
            this.setBiome(x, y, z, bio);
        }
    }

    @Override
    public void setBiome(int x, int y, int z, Holder<Biome> bb) {
        BlockPos pos = new BlockPos(x, 0, z);
        if (this.world.hasChunkAt(pos)) {
            LevelChunk chunk = this.world.getChunkAt(pos);
            chunk.setBiome(x >> 2, y >> 2, z >> 2, bb);
            chunk.markUnsaved();
        }
    }

    public double getTemperature(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        return this.world.getNoiseBiome(x >> 2, y >> 2, z >> 2).value().getTemperature(pos, this.world.getSeaLevel());
    }

    public double getHumidity(int x, int y, int z) {
        return this.world.getNoiseBiome((int)(x >> 2), (int)(y >> 2), (int)(z >> 2)).value().climateSettings.downfall();
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public Iterable<net.minecraft.world.entity.Entity> getNMSEntities() {
        return this.getHandle().getEntities().getAll();
    }

    @Override
    public void addEntityToWorld(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().addFreshEntity(entity, reason);
    }

    @Override
    public void addEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().tryAddFreshEntityWithPassengers(entity, reason);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z, Predicate<? super Entity> filter) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)this.equals(location.getWorld()), (Object)"Location cannot be in a different world");
        BoundingBox aabb = BoundingBox.of((Location)location, (double)x, (double)y, (double)z);
        return this.getNearbyEntities(aabb, filter);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<? super Entity> filter) {
        AsyncCatcher.catchOp("getNearbyEntities");
        Preconditions.checkArgument((boundingBox != null ? 1 : 0) != 0, (Object)"BoundingBox cannot be null");
        AABB bb = new AABB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.world.entity.Entity> entityList = this.getHandle().getEntities((net.minecraft.world.entity.Entity)null, bb, (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (net.minecraft.world.entity.Entity entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    public RayTraceResult rayTraceEntities(Position start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        Location location;
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((!(start instanceof Location) || this.equals((location = (Location)start).getWorld()) ? 1 : 0) != 0, (Object)"Location start cannot be in a different world");
        Preconditions.checkArgument((boolean)start.isFinite(), (Object)"Location start is not finite");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    public RayTraceResult rayTraceBlocks(Position start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, Predicate<? super org.bukkit.block.Block> canCollide) {
        Location location;
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((!(start instanceof Location) || this.equals((location = (Location)start).getWorld()) ? 1 : 0) != 0, (Object)"Location start cannot be in a different world");
        Preconditions.checkArgument((boolean)start.isFinite(), (Object)"Location start is not finite");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vec3 startPos = MCUtil.toVec3(start);
        Vec3 endPos = startPos.add(dir.getX(), dir.getY(), dir.getZ());
        BlockHitResult hitResult = this.getHandle().clip(new ClipContext(startPos, endPos, ignorePassableBlocks ? ClipContext.Block.COLLIDER : ClipContext.Block.OUTLINE, CraftFluidCollisionMode.toFluid(fluidCollisionMode), CollisionContext.empty()), canCollide);
        return CraftRayTraceResult.convertFromInternal(this.getHandle(), hitResult);
    }

    public RayTraceResult rayTrace(Position start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter, Predicate<? super org.bukkit.block.Block> canCollide) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, canCollide);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        if (entityHitDistanceSquared < blockHitDistance * blockHitDistance) {
            return entityHit;
        }
        return blockHit;
    }

    public RayTraceResult rayTrace(Consumer<PositionedRayTraceConfigurationBuilder> builderConsumer) {
        PositionedRayTraceConfigurationBuilderImpl builder = new PositionedRayTraceConfigurationBuilderImpl();
        builderConsumer.accept(builder);
        Preconditions.checkArgument((builder.start != null ? 1 : 0) != 0, (Object)"Start location cannot be null");
        Preconditions.checkArgument((builder.direction != null ? 1 : 0) != 0, (Object)"Direction vector cannot be null");
        Preconditions.checkArgument((boolean)builder.maxDistance.isPresent(), (Object)"Max distance must be set");
        Preconditions.checkArgument((!builder.targets.isEmpty() ? 1 : 0) != 0, (Object)"At least one target");
        double maxDistance = builder.maxDistance.getAsDouble();
        if (builder.targets.contains(RayTraceTarget.ENTITY)) {
            if (builder.targets.contains(RayTraceTarget.BLOCK)) {
                return this.rayTrace((Position)builder.start, builder.direction, maxDistance, builder.fluidCollisionMode, builder.ignorePassableBlocks, builder.raySize, builder.entityFilter, builder.blockFilter);
            }
            return this.rayTraceEntities(builder.start, builder.direction, maxDistance, builder.raySize, builder.entityFilter);
        }
        return this.rayTraceBlocks((Position)builder.start, builder.direction, maxDistance, builder.fluidCollisionMode, builder.ignorePassableBlocks, builder.blockFilter);
    }

    public List<org.bukkit.entity.Player> getPlayers() {
        ArrayList<org.bukkit.entity.Player> list = new ArrayList<org.bukkit.entity.Player>(this.world.players().size());
        for (Player player : this.world.players()) {
            CraftHumanEntity bukkitEntity = player.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof org.bukkit.entity.Player)) continue;
            list.add((org.bukkit.entity.Player)bukkitEntity);
        }
        return list;
    }

    public Entity getEntity(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        net.minecraft.world.entity.Entity entity = this.world.getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void save(boolean flush) {
        AsyncCatcher.catchOp("world save");
        this.server.checkSaveState();
        boolean oldSave = this.world.noSave;
        this.world.noSave = false;
        this.world.save(null, flush, false);
        this.world.noSave = oldSave;
    }

    public boolean isAutoSave() {
        return !this.world.noSave;
    }

    public void setAutoSave(boolean value) {
        this.world.noSave = !value;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().getServer().setDifficulty(this.getHandle(), CraftDifficulty.toMinecraft(difficulty), null, true);
    }

    public Difficulty getDifficulty() {
        return CraftDifficulty.toBukkit(this.getHandle().getDifficulty());
    }

    public int getViewDistance() {
        return FeatureHooks.getViewDistance(this.world);
    }

    public int getSimulationDistance() {
        return FeatureHooks.getSimulationDistance(this.world);
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public boolean hasStorm() {
        return this.world.levelData.isRaining();
    }

    public void setStorm(boolean hasStorm) {
        this.world.serverLevelData.setRaining(hasStorm, WeatherChangeEvent.Cause.PLUGIN);
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getWeatherDuration() {
        return this.world.serverLevelData.getRainTime();
    }

    public void setWeatherDuration(int duration) {
        this.world.serverLevelData.setRainTime(duration);
    }

    public boolean isThundering() {
        return this.world.levelData.isThundering();
    }

    public void setThundering(boolean thundering) {
        this.world.serverLevelData.setThundering(thundering, ThunderChangeEvent.Cause.PLUGIN);
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getThunderDuration() {
        return this.world.serverLevelData.getThunderTime();
    }

    public void setThunderDuration(int duration) {
        this.world.serverLevelData.setThunderTime(duration);
    }

    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    public void setClearWeatherDuration(int duration) {
        this.world.serverLevelData.setClearWeatherTime(duration);
    }

    public int getClearWeatherDuration() {
        return this.world.serverLevelData.getClearWeatherTime();
    }

    public long getSeed() {
        return this.world.getSeed();
    }

    public boolean getPVP() {
        return this.world.pvpMode.toBooleanOrElseGet(() -> this.world.getGameRules().getBoolean(GameRules.RULE_PVP));
    }

    public void setPVP(boolean pvp) {
        if (this.world.getGameRules().getBoolean(GameRules.RULE_PVP) == pvp) {
            return;
        }
        this.world.pvpMode = TriState.byBoolean((boolean)pvp);
    }

    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.isApplicable(data), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World of Location cannot be null");
        int packetData = effect.getId();
        ClientboundLevelEventPacket packet = new ClientboundLevelEventPacket(packetData, CraftLocation.toBlockPosition(location), data, false);
        radius *= radius;
        for (org.bukkit.entity.Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().connection == null || !location.getWorld().equals((Object)player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().connection.send(packet);
        }
    }

    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material.%s must be a block", (Object)material);
        FallingBlockEntity entity = new FallingBlockEntity(this.world, location.getX(), location.getY(), location.getZ(), CraftBlockType.bukkitToMinecraft(material).defaultBlockState());
        entity.time = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        FallingBlockEntity entity = new FallingBlockEntity(this.world, location.getX(), location.getY(), location.getZ(), ((CraftBlockData)data).getState());
        entity.time = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x, z, this, includeBiome, includeBiomeTempRain);
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.getChunkSource().setSpawnSettings(allowMonsters, allowAnimals);
    }

    public boolean getAllowAnimals() {
        return this.world.getChunkSource().spawnFriendlies;
    }

    public boolean getAllowMonsters() {
        return this.world.getChunkSource().spawnEnemies;
    }

    public int getMinHeight() {
        return this.world.getMinY();
    }

    public int getMaxHeight() {
        return this.world.getMaxY() + 1;
    }

    public int getMaxY() {
        return this.world.getMaxY();
    }

    public int getLogicalHeight() {
        return this.world.dimensionType().logicalHeight();
    }

    public boolean isNatural() {
        return this.world.dimensionType().natural();
    }

    public boolean isBedWorks() {
        return this.world.dimensionType().bedWorks();
    }

    public boolean hasSkyLight() {
        return this.world.dimensionType().hasSkyLight();
    }

    public boolean hasCeiling() {
        return this.world.dimensionType().hasCeiling();
    }

    public boolean isPiglinSafe() {
        return this.world.dimensionType().piglinSafe();
    }

    public boolean isRespawnAnchorWorks() {
        return this.world.dimensionType().respawnAnchorWorks();
    }

    public boolean hasRaids() {
        return this.world.dimensionType().hasRaids();
    }

    public boolean isUltraWarm() {
        return this.world.dimensionType().ultraWarm();
    }

    public int getSeaLevel() {
        return this.world.getSeaLevel();
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    public Path getWorldPath() {
        return this.world.levelStorageAccess.getLevelPath(LevelResource.ROOT).getParent();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (org.bukkit.entity.Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (org.bukkit.entity.Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public WorldType getWorldType() {
        return this.world.isFlat() ? WorldType.FLAT : WorldType.NORMAL;
    }

    public boolean canGenerateStructures() {
        return this.world.serverLevelData.worldGenOptions().generateStructures();
    }

    public boolean hasBonusChest() {
        return this.world.serverLevelData.worldGenOptions().generateBonusChest();
    }

    public boolean isHardcore() {
        return this.world.getLevelData().isHardcore();
    }

    public void setHardcore(boolean hardcore) {
        this.world.serverLevelData.settings.hardcore = hardcore;
    }

    public void setTicksPerSpawns(SpawnCategory spawnCategory, int ticksPerCategorySpawn) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.world.ticksPerSpawnCategory.put((Object)spawnCategory, (long)ticksPerCategorySpawn);
    }

    public long getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.world.ticksPerSpawnCategory.getLong((Object)spawnCategory);
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public int getSpawnLimit(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.getSpawnLimitUnsafe(spawnCategory);
    }

    public final int getSpawnLimitUnsafe(SpawnCategory spawnCategory) {
        int limit = this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
        if (limit < 0) {
            limit = this.server.getSpawnLimitUnsafe(spawnCategory);
        }
        return limit;
    }

    public void setSpawnLimit(SpawnCategory spawnCategory, int limit) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.spawnCategoryLimit.put((Object)spawnCategory, limit);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        AsyncCatcher.catchOp("play sound");
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        this.getHandle().playSeededSound(null, x, y, z, CraftSound.bukkitToMinecraft(sound), SoundSource.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        AsyncCatcher.catchOp("play sound");
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        ClientboundSoundPacket packet = new ClientboundSoundPacket(Holder.direct(SoundEvent.createVariableRangeEvent(ResourceLocation.parse(sound))), SoundSource.valueOf(category.name()), x, y, z, volume, pitch, seed);
        this.world.getServer().getPlayerList().broadcast(null, x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.dimension(), packet);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().random.nextLong());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                AsyncCatcher.catchOp("play sound");
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        ClientboundSoundEntityPacket packet = new ClientboundSoundEntityPacket(CraftSound.bukkitToMinecraftHolder(sound), SoundSource.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)this.getHandle().getChunkSource().chunkMap.entityMap.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.sendToTrackingPlayersAndSelf(packet);
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound) {
        AsyncCatcher.catchOp("play sound");
        long seed = sound.seed().orElseGet(this.world.getRandom()::nextLong);
        for (ServerPlayer player : this.getHandle().players()) {
            player.connection.send(PaperAdventure.asSoundPacket(sound, player.getX(), player.getY(), player.getZ(), seed, null));
        }
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                AsyncCatcher.catchOp("play sound");
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        ClientboundSoundEntityPacket packet = new ClientboundSoundEntityPacket(Holder.direct(SoundEvent.createVariableRangeEvent(ResourceLocation.parse(sound))), SoundSource.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)this.getHandle().getChunkSource().chunkMap.entityMap.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.sendToTrackingPlayersAndSelf(packet);
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, double x, double y, double z) {
        AsyncCatcher.catchOp("play sound");
        PaperAdventure.asSoundPacket(sound, x, y, z, sound.seed().orElseGet(this.world.getRandom()::nextLong), this.playSound0(x, y, z));
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, Sound.Emitter emitter) {
        AsyncCatcher.catchOp("play sound");
        long seed = sound.seed().orElseGet(this.getHandle().getRandom()::nextLong);
        if (emitter == Sound.Emitter.self()) {
            for (ServerPlayer player : this.getHandle().players()) {
                player.connection.send(PaperAdventure.asSoundPacket(sound, player, seed, null));
            }
        } else if (emitter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)emitter;
            net.minecraft.world.entity.Entity entity = craftEntity.getHandle();
            PaperAdventure.asSoundPacket(sound, entity, seed, this.playSound0(entity.getX(), entity.getY(), entity.getZ()));
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + String.valueOf(emitter));
        }
    }

    private BiConsumer<Packet<?>, Float> playSound0(double x, double y, double z) {
        return (packet, distance) -> this.world.getServer().getPlayerList().broadcast(null, x, y, z, distance.floatValue(), this.world.dimension(), (Packet<?>)packet);
    }

    public synchronized Map<String, GameRules.Key<?>> getGameRulesNMS() {
        if (this.gamerules != null) {
            return this.gamerules;
        }
        this.gamerules = CraftWorld.getGameRulesNMS(this.getHandle().getGameRules());
        return this.gamerules;
    }

    public static Map<String, GameRules.Key<?>> getGameRulesNMS(GameRules gameRules) {
        final HashMap gamerules = new HashMap();
        gameRules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                gamerules.put(key.getId(), key);
            }
        });
        return gamerules;
    }

    public synchronized Map<String, GameRules.Type<?>> getGameRuleDefinitions() {
        if (this.gameruleDefinitions != null) {
            return this.gameruleDefinitions;
        }
        final HashMap gameruleDefinitions = new HashMap();
        this.getHandle().getGameRules().visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                gameruleDefinitions.put(key.getId(), type);
            }
        });
        this.gameruleDefinitions = gameruleDefinitions;
        return this.gameruleDefinitions;
    }

    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        Object value = this.getHandle().getGameRules().getRule(this.getGameRulesNMS().get(rule));
        return value != null ? ((GameRules.Value)value).toString() : "";
    }

    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, gameRule, value);
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().getGameRules().getRule(this.getGameRulesNMS().get(rule));
        ((GameRules.Value)handle).deserialize(event.getValue());
        ((GameRules.Value)handle).onChanged(this.getHandle());
        return true;
    }

    public String[] getGameRules() {
        return this.getGameRulesNMS().keySet().toArray(new String[this.getGameRulesNMS().size()]);
    }

    public boolean isGameRule(String rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"String rule cannot be null");
        Preconditions.checkArgument((!rule.isEmpty() ? 1 : 0) != 0, (Object)"String rule cannot be empty");
        return this.getGameRulesNMS().containsKey(rule);
    }

    public <T> T getGameRuleValue(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        GameRules.Key<?> key = this.getGameRulesNMS().get(rule.getName());
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"GameRule '%s' is not available", (Object)rule.getName());
        return this.getGameRuleResult(rule, (GameRules.Value<?>)this.getHandle().getGameRules().getRule(key));
    }

    public <T> T getGameRuleDefault(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        GameRules.Type<?> type = this.getGameRuleDefinitions().get(rule.getName());
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"GameRule '%s' is not available", (Object)rule.getName());
        return this.getGameRuleResult(rule, (GameRules.Value<?>)type.createRule());
    }

    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Preconditions.checkArgument((newValue != null ? 1 : 0) != 0, (Object)"GameRule value cannot be null");
        if (!this.isGameRule(rule.getName())) {
            return false;
        }
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, rule, String.valueOf(newValue));
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().getGameRules().getRule(this.getGameRulesNMS().get(rule.getName()));
        ((GameRules.Value)handle).deserialize(event.getValue());
        ((GameRules.Value)handle).onChanged(this.getHandle());
        return true;
    }

    private <T> T getGameRuleResult(GameRule<T> rule, GameRules.Value<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof GameRules.BooleanValue) {
            return rule.getType().cast(((GameRules.BooleanValue)value).get());
        }
        if (value instanceof GameRules.IntegerValue) {
            return rule.getType().cast(value.getCommandResult());
        }
        throw new IllegalArgumentException("Invalid GameRule type (" + String.valueOf(value) + ") for GameRule " + rule.getName());
    }

    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, List<org.bukkit.entity.Player> receivers, org.bukkit.entity.Player sender, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        if ((data = CraftParticle.convertLegacy(data)) != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        this.getHandle().sendParticlesSource(receivers == null ? this.getHandle().players() : Lists.transform(receivers, player -> ((CraftPlayer)player).getHandle()), sender != null ? ((CraftPlayer)sender).getHandle() : null, CraftParticle.createParticleParam(particle, data), force, false, x, y, z, count, offsetX, offsetY, offsetZ, extra);
    }

    @Deprecated
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        StructureSearchResult result = null;
        if (StructureType.MINESHAFT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.MINESHAFT, radius, findUnexplored);
        } else if (StructureType.VILLAGE == structureType) {
            result = this.locateNearestStructure(origin, List.of(Structure.VILLAGE_DESERT, Structure.VILLAGE_PLAINS, Structure.VILLAGE_SAVANNA, Structure.VILLAGE_SNOWY, Structure.VILLAGE_TAIGA), radius, findUnexplored);
        } else if (StructureType.NETHER_FORTRESS == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.FORTRESS, radius, findUnexplored);
        } else if (StructureType.STRONGHOLD == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.STRONGHOLD, radius, findUnexplored);
        } else if (StructureType.JUNGLE_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.JUNGLE_TEMPLE, radius, findUnexplored);
        } else if (StructureType.OCEAN_RUIN == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_RUIN, radius, findUnexplored);
        } else if (StructureType.DESERT_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.DESERT_PYRAMID, radius, findUnexplored);
        } else if (StructureType.IGLOO == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.IGLOO, radius, findUnexplored);
        } else if (StructureType.SWAMP_HUT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SWAMP_HUT, radius, findUnexplored);
        } else if (StructureType.OCEAN_MONUMENT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_MONUMENT, radius, findUnexplored);
        } else if (StructureType.END_CITY == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.END_CITY, radius, findUnexplored);
        } else if (StructureType.WOODLAND_MANSION == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.WOODLAND_MANSION, radius, findUnexplored);
        } else if (StructureType.BURIED_TREASURE == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.BURIED_TREASURE, radius, findUnexplored);
        } else if (StructureType.SHIPWRECK == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SHIPWRECK, radius, findUnexplored);
        } else if (StructureType.PILLAGER_OUTPOST == structureType) {
            result = this.locateNearestStructure(origin, Structure.PILLAGER_OUTPOST, radius, findUnexplored);
        } else if (StructureType.NETHER_FOSSIL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.NETHER_FOSSIL, radius, findUnexplored);
        } else if (StructureType.RUINED_PORTAL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.RUINED_PORTAL, radius, findUnexplored);
        } else if (StructureType.BASTION_REMNANT == structureType) {
            result = this.locateNearestStructure(origin, Structure.BASTION_REMNANT, radius, findUnexplored);
        }
        return result == null ? null : result.getLocation();
    }

    public StructureSearchResult locateNearestStructure(Location origin, org.bukkit.generator.structure.StructureType structureType, int radius, boolean findUnexplored) {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        for (Structure structure : RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE)) {
            if (structure.getStructureType() != structureType) continue;
            structures.add(structure);
        }
        return this.locateNearestStructure(origin, structures, radius, findUnexplored);
    }

    public StructureSearchResult locateNearestStructure(Location origin, Structure structure, int radius, boolean findUnexplored) {
        return this.locateNearestStructure(origin, List.of(structure), radius, findUnexplored);
    }

    private StructureSearchResult locateNearestStructure(Location origin, List<Structure> structures, int radius, boolean findUnexplored) {
        BlockPos originPos = BlockPos.containing(origin.getX(), origin.getY(), origin.getZ());
        ArrayList<Holder<net.minecraft.world.level.levelgen.structure.Structure>> holders = new ArrayList<Holder<net.minecraft.world.level.levelgen.structure.Structure>>();
        for (Structure structure : structures) {
            holders.add(Holder.direct(CraftStructure.bukkitToMinecraft(structure)));
        }
        Pair<BlockPos, Holder<net.minecraft.world.level.levelgen.structure.Structure>> found = this.getHandle().getChunkSource().getGenerator().findNearestMapStructure(this.getHandle(), HolderSet.direct(holders), originPos, radius, findUnexplored);
        if (found == null) {
            return null;
        }
        return new CraftStructureSearchResult(CraftStructure.minecraftToBukkit((net.minecraft.world.level.levelgen.structure.Structure)((Holder)found.getSecond()).value()), CraftLocation.toBukkit((Vec3i)found.getFirst(), (World)this));
    }

    public double getCoordinateScale() {
        return this.getHandle().dimensionType().coordinateScale();
    }

    public boolean isFixedTime() {
        return this.getHandle().dimensionType().hasFixedTime();
    }

    public Collection<Material> getInfiniburn() {
        return Sets.newHashSet((Iterator)Iterators.transform(BuiltInRegistries.BLOCK.getTagOrEmpty(this.getHandle().dimensionType().infiniburn()).iterator(), blockHolder -> CraftBlockType.minecraftToBukkit((Block)blockHolder.value())));
    }

    public void sendGameEvent(Entity sourceEntity, GameEvent gameEvent, Vector position) {
        this.getHandle().gameEvent(sourceEntity != null ? ((CraftEntity)sourceEntity).getHandle() : null, (Holder<net.minecraft.world.level.gameevent.GameEvent>)BuiltInRegistries.GAME_EVENT.get(CraftNamespacedKey.toMinecraft(gameEvent.getKey())).orElseThrow(), CraftVector.toBlockPos(position));
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, int horizontalInterval, int verticalInterval, org.bukkit.block.Biome ... biomes) {
        BlockPos originPos = BlockPos.containing(origin.getX(), origin.getY(), origin.getZ());
        HashSet<Holder<Biome>> holders = new HashSet<Holder<Biome>>();
        for (org.bukkit.block.Biome biome : biomes) {
            holders.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        Climate.Sampler sampler = this.getHandle().getChunkSource().randomState().sampler();
        Pair<BlockPos, Holder<Biome>> found = this.getHandle().getChunkSource().getGenerator().getBiomeSource().findClosestBiome3d(originPos, radius, horizontalInterval, verticalInterval, holders::contains, sampler, this.getHandle());
        if (found == null) {
            return null;
        }
        return new CraftBiomeSearchResult(CraftBiome.minecraftHolderToBukkit((Holder)found.getSecond()), CraftLocation.toBukkit((Vec3i)found.getFirst(), (World)this));
    }

    public Raid locateNearestRaid(Location location, int radius) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (String)"Radius value (%s) cannot be negative", (int)radius);
        Raids persistentRaid = this.world.getRaids();
        net.minecraft.world.entity.raid.Raid raid = persistentRaid.getNearbyRaid(CraftLocation.toBlockPosition(location), radius * radius);
        return raid == null ? null : new CraftRaid(raid, this.world);
    }

    @Nullable
    public Raid getRaid(int id) {
        @Nullable net.minecraft.world.entity.raid.Raid nmsRaid = (net.minecraft.world.entity.raid.Raid)this.world.getRaids().raidMap.get(id);
        return nmsRaid != null ? new CraftRaid(nmsRaid, this.world) : null;
    }

    public List<Raid> getRaids() {
        Raids persistentRaid = this.world.getRaids();
        return persistentRaid.raidMap.values().stream().map(raid -> new CraftRaid((net.minecraft.world.entity.raid.Raid)raid, this.world)).collect(Collectors.toList());
    }

    public DragonBattle getEnderDragonBattle() {
        return this.getHandle().getDragonFight() == null ? null : new CraftDragonBattle(this.getHandle().getDragonFight());
    }

    public float getLocalDifficultyAt(Location location) {
        return this.getHandle().getCurrentDifficultyAt(CraftLocation.toBlockPosition(location)).getEffectiveDifficulty();
    }

    public void sendBlockHighlight(Location location, int duration) {
        this.sendBlockHighlight(location, duration, "", 1677786880);
    }

    public void sendBlockHighlight(Location location, int duration, int argb) {
        this.sendBlockHighlight(location, duration, "", argb);
    }

    public void sendBlockHighlight(Location location, int duration, String text) {
        this.sendBlockHighlight(location, duration, text, 1677786880);
    }

    public void sendBlockHighlight(Location location, int duration, String text, int argb) {
    }

    public void sendBlockHighlight(Location location, int duration, Color color, int transparency) {
        this.sendBlockHighlight(location, duration, "", color, transparency);
    }

    public void sendBlockHighlight(Location location, int duration, String text, Color color, int transparency) {
        if (transparency < 0 || transparency > 255) {
            throw new IllegalArgumentException("transparency is outside of 0-255 range");
        }
        this.sendBlockHighlight(location, duration, text, transparency << 24 | color.asRGB());
    }

    public void clearBlockHighlights() {
    }

    public Collection<GeneratedStructure> getStructures(int x, int z) {
        return this.getStructures(x, z, (net.minecraft.world.level.levelgen.structure.Structure struct) -> true);
    }

    public Collection<GeneratedStructure> getStructures(int x, int z, Structure structure) {
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        Registry<net.minecraft.world.level.levelgen.structure.Structure> registry = CraftRegistry.getMinecraftRegistry(Registries.STRUCTURE);
        ResourceLocation key = registry.getKey(CraftStructure.bukkitToMinecraft(structure));
        return this.getStructures(x, z, (net.minecraft.world.level.levelgen.structure.Structure struct) -> registry.getKey((net.minecraft.world.level.levelgen.structure.Structure)struct).equals(key));
    }

    private List<GeneratedStructure> getStructures(int x, int z, Predicate<net.minecraft.world.level.levelgen.structure.Structure> predicate) {
        ArrayList<GeneratedStructure> structures = new ArrayList<GeneratedStructure>();
        for (StructureStart start : this.getHandle().structureManager().startsForStructure(new ChunkPos(x, z), predicate)) {
            structures.add(new CraftGeneratedStructure(start));
        }
        return structures;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public void storeBukkitValues(CompoundTag tag) {
        if (!this.persistentDataContainer.isEmpty()) {
            tag.put("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.persistentDataContainer.putAll(compoundTag);
        }
    }

    public World.Spigot spigot() {
        return this.spigot;
    }

    public void getChunkAtAsync(int x, int z, boolean gen, boolean urgent, @NotNull Consumer<? super Chunk> cb) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", x, z);
        PlatformHooks.get().scheduleChunkLoad(this.getHandle(), x, z, gen, ChunkStatus.FULL, true, urgent ? Priority.HIGHER : Priority.NORMAL, chunk -> cb.accept(chunk == null ? null : new CraftChunk((LevelChunk)chunk)));
    }

    public void getChunksAtAsync(int minX, int minZ, int maxX, int maxZ, boolean urgent, Runnable cb) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", minX, minZ);
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", maxX, maxZ);
        this.getHandle().loadChunks(minX, minZ, maxX, maxZ, urgent ? Priority.HIGHER : Priority.NORMAL, chunks -> cb.run());
    }

    public void setViewDistance(int viewDistance) {
        FeatureHooks.setViewDistance(this.world, viewDistance);
    }

    public void setSimulationDistance(int simulationDistance) {
        FeatureHooks.setSimulationDistance(this.world, simulationDistance);
    }

    public int getSendViewDistance() {
        return FeatureHooks.getSendViewDistance(this.world);
    }

    public void setSendViewDistance(int viewDistance) {
        FeatureHooks.setSendViewDistance(this.world, viewDistance);
    }

    public Pointers pointers() {
        return POINTERS_SUPPLIER.view((Object)this);
    }
}

