/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Barrel;
import org.bukkit.craftbukkit.block.CraftLootable;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.inventory.Inventory;

public class CraftBarrel
extends CraftLootable<BarrelBlockEntity>
implements Barrel {
    public CraftBarrel(World world, BarrelBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftBarrel(CraftBarrel state, Location location) {
        super(state, location);
    }

    public Inventory getSnapshotInventory() {
        return new CraftInventory((Container)this.getSnapshot());
    }

    public Inventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((Container)this.getBlockEntity());
    }

    public void open() {
        BlockState state;
        boolean open;
        this.requirePlaced();
        if (!((BarrelBlockEntity)this.getBlockEntity()).openersCounter.opened && !(open = (state = ((BarrelBlockEntity)this.getBlockEntity()).getBlockState()).getValue(BarrelBlock.OPEN).booleanValue())) {
            ((BarrelBlockEntity)this.getBlockEntity()).updateBlockState(state, true);
            if (this.getWorldHandle() instanceof Level) {
                ((BarrelBlockEntity)this.getBlockEntity()).playSound(state, SoundEvents.BARREL_OPEN);
            }
        }
        ((BarrelBlockEntity)this.getBlockEntity()).openersCounter.opened = true;
    }

    public void close() {
        this.requirePlaced();
        if (((BarrelBlockEntity)this.getBlockEntity()).openersCounter.opened) {
            BlockState state = ((BarrelBlockEntity)this.getBlockEntity()).getBlockState();
            ((BarrelBlockEntity)this.getBlockEntity()).updateBlockState(state, false);
            if (this.getWorldHandle() instanceof Level) {
                ((BarrelBlockEntity)this.getBlockEntity()).playSound(state, SoundEvents.BARREL_CLOSE);
            }
        }
        ((BarrelBlockEntity)this.getBlockEntity()).openersCounter.opened = false;
    }

    @Override
    public CraftBarrel copy() {
        return new CraftBarrel(this, null);
    }

    @Override
    public CraftBarrel copy(Location location) {
        return new CraftBarrel(this, location);
    }

    public boolean isOpen() {
        return ((BarrelBlockEntity)this.getBlockEntity()).openersCounter.opened;
    }
}

