/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import net.minecraft.world.Container;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Dispenser;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftLootable;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.projectiles.CraftBlockProjectileSource;
import org.bukkit.inventory.Inventory;
import org.bukkit.projectiles.BlockProjectileSource;

public class CraftDispenser
extends CraftLootable<DispenserBlockEntity>
implements Dispenser {
    public CraftDispenser(World world, DispenserBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftDispenser(CraftDispenser state, Location location) {
        super(state, location);
    }

    public Inventory getSnapshotInventory() {
        return new CraftInventory((Container)this.getSnapshot());
    }

    public Inventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((Container)this.getBlockEntity());
    }

    public BlockProjectileSource getBlockProjectileSource() {
        CraftBlock block = this.getBlock();
        if (block.getType() != Material.DISPENSER) {
            return null;
        }
        return new CraftBlockProjectileSource((DispenserBlockEntity)this.getBlockEntityFromWorld());
    }

    public boolean dispense() {
        this.ensureNoWorldGeneration();
        CraftBlock block = this.getBlock();
        if (block.getType() == Material.DISPENSER) {
            CraftWorld world = (CraftWorld)this.getWorld();
            DispenserBlock dispense = (DispenserBlock)Blocks.DISPENSER;
            dispense.dispenseFrom(world.getHandle(), this.getHandle(), this.getPosition());
            return true;
        }
        return false;
    }

    @Override
    public CraftDispenser copy() {
        return new CraftDispenser(this, null);
    }

    @Override
    public CraftDispenser copy(Location location) {
        return new CraftDispenser(this, location);
    }
}

