/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.util.MCUtil;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.block.CraftContainer;
import org.bukkit.craftbukkit.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;

public abstract class CraftFurnace<T extends AbstractFurnaceBlockEntity>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T blockEntity) {
        super(world, blockEntity);
    }

    protected CraftFurnace(CraftFurnace<T> state, Location location) {
        super(state, location);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((AbstractFurnaceBlockEntity)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((AbstractFurnaceBlockEntity)this.getBlockEntity());
    }

    public short getBurnTime() {
        return (short)((AbstractFurnaceBlockEntity)this.getSnapshot()).litTimeRemaining;
    }

    public void setBurnTime(short burnTime) {
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).litTimeRemaining = burnTime;
        this.data = (BlockState)this.data.trySetValue(AbstractFurnaceBlock.LIT, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((AbstractFurnaceBlockEntity)this.getSnapshot()).cookingTimer;
    }

    public void setCookTime(short cookTime) {
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).cookingTimer = cookTime;
    }

    public int getCookTimeTotal() {
        return ((AbstractFurnaceBlockEntity)this.getSnapshot()).cookingTotalTime;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).cookingTotalTime = cookTimeTotal;
    }

    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        ImmutableMap.Builder recipesUsed = ImmutableMap.builder();
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).recipesUsed.reference2IntEntrySet().fastForEach(entrySet -> {
            org.bukkit.inventory.Recipe recipe = Bukkit.getRecipe((NamespacedKey)CraftNamespacedKey.fromMinecraft(((ResourceKey)entrySet.getKey()).location()));
            if (recipe instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                recipesUsed.put((Object)cookingRecipe, (Object)entrySet.getValue());
            }
        });
        return recipesUsed.build();
    }

    @Override
    public abstract CraftFurnace<T> copy();

    @Override
    public abstract CraftFurnace<T> copy(Location var1);

    public double getCookSpeedMultiplier() {
        return ((AbstractFurnaceBlockEntity)this.getSnapshot()).cookSpeedMultiplier;
    }

    public void setCookSpeedMultiplier(double multiplier) {
        Preconditions.checkArgument((multiplier >= 0.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot be negative");
        Preconditions.checkArgument((multiplier <= 200.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot more than 200");
        AbstractFurnaceBlockEntity snapshot = (AbstractFurnaceBlockEntity)this.getSnapshot();
        snapshot.cookSpeedMultiplier = multiplier;
        snapshot.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(this.isPlaced() ? this.world.getHandle() : null, snapshot, snapshot.recipeType, snapshot.cookSpeedMultiplier);
    }

    public int getRecipeUsedCount(NamespacedKey furnaceRecipe) {
        return ((AbstractFurnaceBlockEntity)this.getSnapshot()).recipesUsed.getInt(MCUtil.toResourceKey(Registries.RECIPE, furnaceRecipe));
    }

    public boolean hasRecipeUsedCount(NamespacedKey furnaceRecipe) {
        return ((AbstractFurnaceBlockEntity)this.getSnapshot()).recipesUsed.containsKey(MCUtil.toResourceKey(Registries.RECIPE, furnaceRecipe));
    }

    public void setRecipeUsedCount(CookingRecipe<?> furnaceRecipe, int count) {
        ResourceKey<Recipe<?>> location = MCUtil.toResourceKey(Registries.RECIPE, furnaceRecipe.getKey());
        Optional<RecipeHolder<?>> nmsRecipe = (this.isPlaced() ? this.world.getHandle().recipeAccess() : MinecraftServer.getServer().getRecipeManager()).byKey(location);
        Preconditions.checkArgument((nmsRecipe.isPresent() && nmsRecipe.get().value() instanceof AbstractCookingRecipe ? 1 : 0) != 0, (Object)(String.valueOf(furnaceRecipe.getKey()) + " is not recognized as a valid and registered furnace recipe"));
        if (count > 0) {
            ((AbstractFurnaceBlockEntity)this.getSnapshot()).recipesUsed.put(location, count);
        } else {
            ((AbstractFurnaceBlockEntity)this.getSnapshot()).recipesUsed.removeInt(location);
        }
    }

    public void setRecipesUsed(Map<CookingRecipe<?>, Integer> recipesUsed) {
        ((AbstractFurnaceBlockEntity)this.getSnapshot()).recipesUsed.clear();
        recipesUsed.forEach((recipe, integer) -> {
            if (integer != null) {
                this.setRecipeUsedCount((CookingRecipe<?>)recipe, (int)integer);
            }
        });
    }
}

