/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.ShulkerBox;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.CraftLootable;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.inventory.Inventory;

public class CraftShulkerBox
extends CraftLootable<ShulkerBoxBlockEntity>
implements ShulkerBox {
    public CraftShulkerBox(World world, ShulkerBoxBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftShulkerBox(CraftShulkerBox state, Location location) {
        super(state, location);
    }

    public Inventory getSnapshotInventory() {
        return new CraftInventory((Container)this.getSnapshot());
    }

    public Inventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((Container)this.getBlockEntity());
    }

    public DyeColor getColor() {
        net.minecraft.world.item.DyeColor color = ((ShulkerBoxBlock)CraftBlockType.bukkitToMinecraft((Material)this.getType())).color;
        return color == null ? null : DyeColor.getByWoolData((byte)((byte)color.getId()));
    }

    public void open() {
        this.requirePlaced();
        if (!((ShulkerBoxBlockEntity)this.getBlockEntity()).opened && this.getWorldHandle() instanceof Level) {
            Level world = ((ShulkerBoxBlockEntity)this.getBlockEntity()).getLevel();
            world.blockEvent(this.getPosition(), ((ShulkerBoxBlockEntity)this.getBlockEntity()).getBlockState().getBlock(), 1, 1);
            world.playSound(null, this.getPosition(), SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }
        ((ShulkerBoxBlockEntity)this.getBlockEntity()).opened = true;
    }

    public void close() {
        this.requirePlaced();
        if (((ShulkerBoxBlockEntity)this.getBlockEntity()).opened && this.getWorldHandle() instanceof Level) {
            Level world = ((ShulkerBoxBlockEntity)this.getBlockEntity()).getLevel();
            world.blockEvent(this.getPosition(), ((ShulkerBoxBlockEntity)this.getBlockEntity()).getBlockState().getBlock(), 1, 0);
            world.playSound(null, this.getPosition(), SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }
        ((ShulkerBoxBlockEntity)this.getBlockEntity()).opened = false;
    }

    @Override
    public CraftShulkerBox copy() {
        return new CraftShulkerBox(this, null);
    }

    @Override
    public CraftShulkerBox copy(Location location) {
        return new CraftShulkerBox(this, location);
    }

    public boolean isOpen() {
        return ((ShulkerBoxBlockEntity)this.getBlockEntity()).opened;
    }
}

