/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Structure;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.util.CraftBlockVector;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockVector;

public class CraftStructureBlock
extends CraftBlockEntityState<StructureBlockEntity>
implements Structure {
    private static final int MAX_SIZE = 48;

    public CraftStructureBlock(World world, StructureBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftStructureBlock(CraftStructureBlock state, Location location) {
        super(state, location);
    }

    public String getStructureName() {
        return ((StructureBlockEntity)this.getSnapshot()).getStructureName();
    }

    public void setStructureName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Structure name cannot be null");
        ((StructureBlockEntity)this.getSnapshot()).setStructureName(name);
    }

    public String getAuthor() {
        return ((StructureBlockEntity)this.getSnapshot()).author;
    }

    public void setAuthor(String author) {
        Preconditions.checkArgument((author != null ? 1 : 0) != 0, (Object)"Author name cannot be null");
        Preconditions.checkArgument((!author.isEmpty() ? 1 : 0) != 0, (Object)"Author name cannot be empty");
        ((StructureBlockEntity)this.getSnapshot()).author = author;
    }

    public void setAuthor(LivingEntity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Structure Block author entity cannot be null");
        ((StructureBlockEntity)this.getSnapshot()).createdBy(((CraftLivingEntity)entity).getHandle());
    }

    public BlockVector getRelativePosition() {
        return CraftBlockVector.toBukkit(((StructureBlockEntity)this.getSnapshot()).structurePos);
    }

    public void setRelativePosition(BlockVector vector) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), -48, 48), (String)"Structure Size (X) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockX());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), -48, 48), (String)"Structure Size (Y) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockY());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), -48, 48), (String)"Structure Size (Z) must be between -%s and %s but got %s", (Object)48, (Object)48, (Object)vector.getBlockZ());
        ((StructureBlockEntity)this.getSnapshot()).structurePos = CraftBlockVector.toBlockPosition(vector);
    }

    public BlockVector getStructureSize() {
        return CraftBlockVector.toBukkit(((StructureBlockEntity)this.getSnapshot()).structureSize);
    }

    public void setStructureSize(BlockVector vector) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), 0, 48), (String)"Structure Size (X) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockX());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), 0, 48), (String)"Structure Size (Y) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockY());
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), 0, 48), (String)"Structure Size (Z) must be between %s and %s but got %s", (Object)0, (Object)48, (Object)vector.getBlockZ());
        ((StructureBlockEntity)this.getSnapshot()).structureSize = CraftBlockVector.toBlockPosition(vector);
    }

    public void setMirror(Mirror mirror) {
        Preconditions.checkArgument((mirror != null ? 1 : 0) != 0, (Object)"Mirror cannot be null");
        ((StructureBlockEntity)this.getSnapshot()).mirror = net.minecraft.world.level.block.Mirror.valueOf(mirror.name());
    }

    public Mirror getMirror() {
        return Mirror.valueOf((String)((StructureBlockEntity)this.getSnapshot()).mirror.name());
    }

    public void setRotation(StructureRotation rotation) {
        Preconditions.checkArgument((rotation != null ? 1 : 0) != 0, (Object)"StructureRotation cannot be null");
        ((StructureBlockEntity)this.getSnapshot()).rotation = Rotation.valueOf(rotation.name());
    }

    public StructureRotation getRotation() {
        return StructureRotation.valueOf((String)((StructureBlockEntity)this.getSnapshot()).rotation.name());
    }

    public void setUsageMode(UsageMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"UsageMode cannot be null");
        ((StructureBlockEntity)this.getSnapshot()).mode = StructureMode.valueOf(mode.name());
    }

    public UsageMode getUsageMode() {
        return UsageMode.valueOf((String)((StructureBlockEntity)this.getSnapshot()).getMode().name());
    }

    public void setIgnoreEntities(boolean flag) {
        ((StructureBlockEntity)this.getSnapshot()).ignoreEntities = flag;
    }

    public boolean isIgnoreEntities() {
        return ((StructureBlockEntity)this.getSnapshot()).ignoreEntities;
    }

    public void setShowAir(boolean showAir) {
        ((StructureBlockEntity)this.getSnapshot()).showAir = showAir;
    }

    public boolean isShowAir() {
        return ((StructureBlockEntity)this.getSnapshot()).showAir;
    }

    public void setBoundingBoxVisible(boolean showBoundingBox) {
        ((StructureBlockEntity)this.getSnapshot()).showBoundingBox = showBoundingBox;
    }

    public boolean isBoundingBoxVisible() {
        return ((StructureBlockEntity)this.getSnapshot()).showBoundingBox;
    }

    public void setIntegrity(float integrity) {
        Preconditions.checkArgument((boolean)CraftStructureBlock.isBetween(integrity, 0.0f, 1.0f), (String)"Integrity must be between 0.0f and 1.0f but got %s", (Object)Float.valueOf(integrity));
        ((StructureBlockEntity)this.getSnapshot()).integrity = integrity;
    }

    public float getIntegrity() {
        return ((StructureBlockEntity)this.getSnapshot()).integrity;
    }

    public void setSeed(long seed) {
        ((StructureBlockEntity)this.getSnapshot()).seed = seed;
    }

    public long getSeed() {
        return ((StructureBlockEntity)this.getSnapshot()).seed;
    }

    public void setMetadata(String metadata) {
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"Structure metadata cannot be null");
        if (this.getUsageMode() == UsageMode.DATA) {
            ((StructureBlockEntity)this.getSnapshot()).metaData = metadata;
        }
    }

    public String getMetadata() {
        return ((StructureBlockEntity)this.getSnapshot()).metaData;
    }

    @Override
    protected void applyTo(StructureBlockEntity blockEntity) {
        BlockState state;
        super.applyTo(blockEntity);
        LevelAccessor access = this.getWorldHandle();
        if (access instanceof Level) {
            blockEntity.setMode(blockEntity.getMode());
        } else if (access != null && (state = access.getBlockState(this.getPosition())).is(Blocks.STRUCTURE_BLOCK)) {
            access.setBlock(this.getPosition(), (BlockState)state.setValue(StructureBlock.MODE, blockEntity.getMode()), 2);
        }
    }

    @Override
    public CraftStructureBlock copy() {
        return new CraftStructureBlock(this, null);
    }

    @Override
    public CraftStructureBlock copy(Location location) {
        return new CraftStructureBlock(this, location);
    }

    private static boolean isBetween(int num, int min, int max) {
        return num >= min && num <= max;
    }

    private static boolean isBetween(float num, float min, float max) {
        return num >= min && num <= max;
    }
}

