/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TrialSpawner;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.block.CraftTrialSpawnerConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.spawner.TrialSpawnerConfiguration;

public class CraftTrialSpawner
extends CraftBlockEntityState<TrialSpawnerBlockEntity>
implements TrialSpawner {
    private final CraftTrialSpawnerConfiguration normalConfig;
    private final CraftTrialSpawnerConfiguration ominousConfig;

    public CraftTrialSpawner(World world, TrialSpawnerBlockEntity blockEntity) {
        super(world, blockEntity);
        this.normalConfig = new CraftTrialSpawnerConfiguration(blockEntity.getTrialSpawner().normalConfig(), (TrialSpawnerBlockEntity)this.getSnapshot());
        this.ominousConfig = new CraftTrialSpawnerConfiguration(blockEntity.getTrialSpawner().ominousConfig(), (TrialSpawnerBlockEntity)this.getSnapshot());
    }

    protected CraftTrialSpawner(CraftTrialSpawner state, Location location) {
        super(state, location);
        this.normalConfig = state.normalConfig;
        this.ominousConfig = state.ominousConfig;
    }

    public long getCooldownEnd() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.getStateData().cooldownEndsAt;
    }

    public void setCooldownEnd(long ticks) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.getStateData().cooldownEndsAt = ticks;
    }

    public long getNextSpawnAttempt() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.getStateData().nextMobSpawnsAt;
    }

    public void setNextSpawnAttempt(long ticks) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.getStateData().nextMobSpawnsAt = ticks;
    }

    public int getCooldownLength() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.getTargetCooldownLength();
    }

    public void setCooldownLength(int ticks) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.config = ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.config.overrideTargetCooldownLength(ticks);
    }

    public int getRequiredPlayerRange() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.getRequiredPlayerRange();
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.config = ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.config.overrideRequiredPlayerRange(requiredPlayerRange);
    }

    public Collection<Player> getTrackedPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().detectedPlayers) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            players.add((Object)player);
        }
        return players.build();
    }

    public boolean isTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        return this.getTrialData().detectedPlayers.contains(player.getUniqueId());
    }

    public void startTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().detectedPlayers.add(player.getUniqueId());
    }

    public void stopTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().detectedPlayers.remove(player.getUniqueId());
    }

    public Collection<Entity> getTrackedEntities() {
        ImmutableSet.Builder entities = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().currentMobs) {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null) continue;
            entities.add((Object)entity);
        }
        return entities.build();
    }

    public boolean isTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getTrialData().currentMobs.contains(entity.getUniqueId());
    }

    public void startTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().currentMobs.add(entity.getUniqueId());
    }

    public void stopTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().currentMobs.remove(entity.getUniqueId());
    }

    public boolean isOminous() {
        return this.data.getValueOrElse(TrialSpawnerBlock.OMINOUS, false);
    }

    public void setOminous(boolean ominous) {
        if (!this.data.hasProperty(TrialSpawnerBlock.OMINOUS)) {
            return;
        }
        ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.isOminous = ominous;
        if (ominous) {
            this.data = (BlockState)this.data.setValue(TrialSpawnerBlock.OMINOUS, true);
            return;
        }
        this.data = (BlockState)this.data.setValue(TrialSpawnerBlock.OMINOUS, false);
    }

    public TrialSpawnerConfiguration getNormalConfiguration() {
        return this.normalConfig;
    }

    public TrialSpawnerConfiguration getOminousConfiguration() {
        return this.ominousConfig;
    }

    @Override
    protected void applyTo(TrialSpawnerBlockEntity blockEntity) {
        super.applyTo(blockEntity);
        blockEntity.trialSpawner.config = blockEntity.trialSpawner.config.overrideConfigs(Holder.direct(this.normalConfig.toMinecraft()), Holder.direct(this.ominousConfig.toMinecraft()));
    }

    private TrialSpawnerStateData getTrialData() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).getTrialSpawner().getStateData();
    }

    @Override
    public CraftTrialSpawner copy() {
        return new CraftTrialSpawner(this, null);
    }

    @Override
    public CraftTrialSpawner copy(Location location) {
        return new CraftTrialSpawner(this, location);
    }
}

