/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftTrapDoor
extends CraftBlockData
implements TrapDoor {
    private static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final EnumProperty<Half> HALF = TrapDoorBlock.HALF;
    private static final BooleanProperty OPEN = TrapDoorBlock.OPEN;
    private static final BooleanProperty POWERED = TrapDoorBlock.POWERED;
    private static final BooleanProperty WATERLOGGED = TrapDoorBlock.WATERLOGGED;

    public CraftTrapDoor(BlockState state) {
        super(state);
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public Bisected.Half getHalf() {
        return this.get(HALF, Bisected.Half.class);
    }

    public void setHalf(Bisected.Half half) {
        Preconditions.checkArgument((half != null ? 1 : 0) != 0, (Object)"half cannot be null!");
        this.set(HALF, half);
    }

    public boolean isOpen() {
        return this.get(OPEN);
    }

    public void setOpen(boolean open) {
        this.set(OPEN, open);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

