/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftTripWire
extends CraftBlockData
implements Tripwire {
    private static final BooleanProperty ATTACHED = TripWireBlock.ATTACHED;
    private static final BooleanProperty DISARMED = TripWireBlock.DISARMED;
    private static final BooleanProperty POWERED = TripWireBlock.POWERED;
    private static final Map<BlockFace, BooleanProperty> PROPERTY_BY_DIRECTION = Map.of(BlockFace.EAST, TripWireBlock.EAST, BlockFace.NORTH, TripWireBlock.NORTH, BlockFace.SOUTH, TripWireBlock.SOUTH, BlockFace.WEST, TripWireBlock.WEST);

    public CraftTripWire(BlockState state) {
        super(state);
    }

    public boolean isAttached() {
        return this.get(ATTACHED);
    }

    public void setAttached(boolean attached) {
        this.set(ATTACHED, attached);
    }

    public boolean isDisarmed() {
        return this.get(DISARMED);
    }

    public void setDisarmed(boolean disarmed) {
        this.set(DISARMED, disarmed);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }

    public boolean hasFace(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        BooleanProperty property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        return this.get(property);
    }

    public void setFace(BlockFace blockFace, boolean face) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        BooleanProperty property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        this.set(property, face);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (Map.Entry<BlockFace, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (!((Boolean)this.get(entry.getValue())).booleanValue()) continue;
            faces.add((Object)entry.getKey());
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        return Collections.unmodifiableSet(PROPERTY_BY_DIRECTION.keySet());
    }
}

