/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.phys.AABB;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftSound;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.AbstractProjectile;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public abstract class CraftAbstractArrow
extends AbstractProjectile
implements org.bukkit.entity.AbstractArrow {
    public CraftAbstractArrow(CraftServer server, AbstractArrow entity) {
        super(server, entity);
    }

    @Override
    public AbstractArrow getHandle() {
        return (AbstractArrow)this.entity;
    }

    public void setKnockbackStrength(int knockbackStrength) {
    }

    public int getKnockbackStrength() {
        return 0;
    }

    public double getDamage() {
        return this.getHandle().baseDamage;
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().setBaseDamage(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().getPierceLevel();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().setPierceLevel((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().isCritArrow();
    }

    public void setCritical(boolean critical) {
        this.getHandle().setCritArrow(critical);
    }

    public boolean isInBlock() {
        return this.getHandle().isInGround();
    }

    public Block getAttachedBlock() {
        return (Block)Iterables.getFirst(this.getAttachedBlocks(), null);
    }

    public List<Block> getAttachedBlocks() {
        if (!this.isInBlock()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(new BlockCollisions<CraftBlock>((CollisionGetter)this.getHandle().level(), (Entity)null, new AABB(this.getHandle().position(), this.getHandle().position()).inflate(0.06), false, (mutableBlockPos, voxelShape) -> CraftBlock.at(this.getHandle().level(), mutableBlockPos)));
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().pickup.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().pickup = AbstractArrow.Pickup.byOrdinal(status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().life = value;
    }

    public boolean isShotFromCrossbow() {
        net.minecraft.world.item.ItemStack firedFromWeapon = this.getHandle().getWeaponItem();
        return firedFromWeapon != null && firedFromWeapon.is(Items.CROSSBOW);
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().pickupItemStack);
    }

    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().pickupItemStack = CraftItemStack.asNMSCopy(item);
    }

    public ItemStack getWeapon() {
        if (this.getHandle().getWeaponItem() == null) {
            return null;
        }
        return CraftItemStack.asBukkitCopy(this.getHandle().getWeaponItem());
    }

    public void setWeapon(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().firedFromWeapon = CraftItemStack.asNMSCopy(item);
    }

    public CraftItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().getPickupItem());
    }

    public void setItemStack(ItemStack stack) {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().setPickupItemStack(CraftItemStack.asNMSCopy(stack));
    }

    public void setLifetimeTicks(int ticks) {
        this.getHandle().life = ticks;
    }

    public int getLifetimeTicks() {
        return this.getHandle().life;
    }

    public Sound getHitSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getHitGroundSoundEvent());
    }

    public void setHitSound(Sound sound) {
        this.getHandle().setSoundEvent(CraftSound.bukkitToMinecraft(sound));
    }

    @Override
    public void setNoPhysics(boolean noPhysics) {
        this.getHandle().setNoPhysics(noPhysics);
    }

    public void setShooter(ProjectileSource shooter, boolean resetPickupStatus) {
        if (shooter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)shooter;
            this.getHandle().setOwner(craftEntity.getHandle(), resetPickupStatus);
        } else {
            this.getHandle().setOwner(null, resetPickupStatus);
        }
        this.getHandle().projectileSource = shooter;
    }
}

