/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.Optionull;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.monster.creaking.Creaking;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftMonster;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftCreaking
extends CraftMonster
implements org.bukkit.entity.Creaking {
    public CraftCreaking(CraftServer server, Creaking entity) {
        super(server, entity);
    }

    @Override
    public Creaking getHandle() {
        return (Creaking)this.entity;
    }

    public @Nullable Location getHome() {
        return Optionull.map(this.getHandle().getHomePos(), pos -> CraftLocation.toBukkit((Vec3i)pos, this.getHandle().level()));
    }

    public void activate(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        this.getHandle().activate(((CraftPlayer)player).getHandle());
    }

    public void deactivate() {
        this.getHandle().deactivate();
    }

    public boolean isActive() {
        return this.getHandle().isActive();
    }
}

