/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Player;

public class CraftFox
extends CraftAnimals
implements org.bukkit.entity.Fox {
    public CraftFox(CraftServer server, Fox entity) {
        super(server, entity);
    }

    @Override
    public Fox getHandle() {
        return (Fox)this.entity;
    }

    public Fox.Type getFoxType() {
        return Fox.Type.values()[this.getHandle().getVariant().ordinal()];
    }

    public void setFoxType(Fox.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        this.getHandle().setVariant(Fox.Variant.values()[type.ordinal()]);
    }

    public boolean isCrouching() {
        return this.getHandle().isCrouching();
    }

    public void setCrouching(boolean crouching) {
        this.getHandle().setIsCrouching(crouching);
    }

    public boolean isSitting() {
        return this.getHandle().isSitting();
    }

    public void setSitting(boolean sitting) {
        this.getHandle().setSitting(sitting);
    }

    public void setSleeping(boolean sleeping) {
        this.getHandle().setSleeping(sleeping);
    }

    private AnimalTamer getTrustedPlayer(EntityDataAccessor<Optional<EntityReference<LivingEntity>>> entityDataKey) {
        return this.getHandle().getEntityData().get(entityDataKey).map(EntityReference::getUUID).map(uuid -> {
            Player player = this.getServer().getPlayer(uuid);
            if (player == null) {
                player = this.getServer().getOfflinePlayer(uuid);
            }
            return player;
        }).orElse(null);
    }

    public AnimalTamer getFirstTrustedPlayer() {
        return this.getTrustedPlayer(Fox.DATA_TRUSTED_ID_0);
    }

    public void setFirstTrustedPlayer(AnimalTamer player) {
        if (player == null) {
            Preconditions.checkState((boolean)this.getHandle().getEntityData().get(Fox.DATA_TRUSTED_ID_1).isEmpty(), (Object)"Must remove second trusted player first");
        }
        this.getHandle().getEntityData().set(Fox.DATA_TRUSTED_ID_0, player == null ? Optional.empty() : Optional.of(EntityReference.of(player.getUniqueId())));
    }

    public AnimalTamer getSecondTrustedPlayer() {
        return this.getTrustedPlayer(Fox.DATA_TRUSTED_ID_1);
    }

    public void setSecondTrustedPlayer(AnimalTamer player) {
        if (player != null) {
            Preconditions.checkState((boolean)this.getHandle().getEntityData().get(Fox.DATA_TRUSTED_ID_0).isPresent(), (Object)"Must add first trusted player first");
        }
        this.getHandle().getEntityData().set(Fox.DATA_TRUSTED_ID_1, player == null ? Optional.empty() : Optional.of(EntityReference.of(player.getUniqueId())));
    }

    public boolean isFaceplanted() {
        return this.getHandle().isFaceplanted();
    }

    public void setInterested(boolean interested) {
        this.getHandle().setIsInterested(interested);
    }

    public boolean isInterested() {
        return this.getHandle().isInterested();
    }

    public void setLeaping(boolean leaping) {
        this.getHandle().setIsPouncing(leaping);
    }

    public boolean isLeaping() {
        return this.getHandle().isPouncing();
    }

    public void setDefending(boolean defending) {
        this.getHandle().setDefending(defending);
    }

    public boolean isDefending() {
        return this.getHandle().isDefending();
    }

    public void setFaceplanted(boolean faceplanted) {
        this.getHandle().setFaceplanted(faceplanted);
    }
}

