/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.inventory.CraftInventoryHorse;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.HorseInventory;

public class CraftHorse
extends CraftAbstractHorse
implements org.bukkit.entity.Horse {
    public CraftHorse(CraftServer server, Horse entity) {
        super(server, entity);
    }

    @Override
    public Horse getHandle() {
        return (Horse)this.entity;
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.HORSE;
    }

    public Horse.Color getColor() {
        return Horse.Color.values()[this.getHandle().getVariant().getId()];
    }

    public void setColor(Horse.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"Color cannot be null");
        this.getHandle().setVariantAndMarkings(Variant.byId(color.ordinal()), this.getHandle().getMarkings());
    }

    public Horse.Style getStyle() {
        return Horse.Style.values()[this.getHandle().getMarkings().getId()];
    }

    public void setStyle(Horse.Style style) {
        Preconditions.checkArgument((style != null ? 1 : 0) != 0, (Object)"Style cannot be null");
        this.getHandle().setVariantAndMarkings(this.getHandle().getVariant(), Markings.byId(style.ordinal()));
    }

    public boolean isCarryingChest() {
        return false;
    }

    public void setCarryingChest(boolean chest) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public HorseInventory getInventory() {
        return new CraftInventoryHorse(this.getHandle().inventory, this.getHandle().createEquipmentSlotContainer(EquipmentSlot.BODY), this.getHandle().createEquipmentSlotContainer(EquipmentSlot.SADDLE));
    }
}

