/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.Llama;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.inventory.CraftInventoryLlama;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;
import org.jetbrains.annotations.NotNull;

public class CraftLlama
extends CraftChestedHorse
implements org.bukkit.entity.Llama,
CraftRangedEntity<Llama> {
    public CraftLlama(CraftServer server, Llama entity) {
        super(server, entity);
    }

    @Override
    public Llama getHandle() {
        return (Llama)this.entity;
    }

    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().getVariant().ordinal()];
    }

    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().setVariant(Llama.Variant.byId(color.ordinal()));
    }

    public LlamaInventory getInventory() {
        return new CraftInventoryLlama(this.getHandle().inventory, this.getHandle().createEquipmentSlotContainer(EquipmentSlot.BODY), this.getHandle().createEquipmentSlotContainer(EquipmentSlot.SADDLE));
    }

    public int getStrength() {
        return this.getHandle().getStrength();
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().setStrength(strength);
        this.getHandle().createInventory();
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    public boolean inCaravan() {
        return this.getHandle().inCaravan();
    }

    public void joinCaravan(@NotNull org.bukkit.entity.Llama llama) {
        this.getHandle().joinCaravan(((CraftLlama)llama).getHandle());
    }

    public void leaveCaravan() {
        this.getHandle().leaveCaravan();
    }

    public boolean hasCaravanTail() {
        return this.getHandle().hasCaravanTail();
    }

    public org.bukkit.entity.Llama getCaravanHead() {
        return this.getHandle().getCaravanHead() == null ? null : (org.bukkit.entity.Llama)this.getHandle().getCaravanHead().getBukkitEntity();
    }

    public org.bukkit.entity.Llama getCaravanTail() {
        return this.getHandle().caravanTail == null ? null : (org.bukkit.entity.Llama)this.getHandle().caravanTail.getBukkitEntity();
    }

    public boolean shouldJoinCaravan() {
        return this.getHandle().shouldJoinCaravan;
    }

    public void setShouldJoinCaravan(boolean shouldJoinCaravan) {
        this.getHandle().shouldJoinCaravan = shouldJoinCaravan;
    }
}

