/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.SkinParts;
import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import net.kyori.adventure.text.Component;
import net.minecraft.Optionull;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.inventory.MainHand;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftMannequin
extends CraftLivingEntity
implements Mannequin {
    public CraftMannequin(CraftServer server, net.minecraft.world.entity.decoration.Mannequin entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.decoration.Mannequin getHandle() {
        return (net.minecraft.world.entity.decoration.Mannequin)this.entity;
    }

    @Override
    public void setPose(org.bukkit.entity.Pose pose, boolean fixed) {
        Preconditions.checkArgument((pose != null ? 1 : 0) != 0, (Object)"pose cannot be null");
        Pose internalPose = Pose.values()[pose.ordinal()];
        if (!net.minecraft.world.entity.decoration.Mannequin.VALID_POSES.contains(internalPose)) {
            throw new IllegalArgumentException("Invalid pose '%s', expected one of: %s".formatted(pose.name(), net.minecraft.world.entity.decoration.Mannequin.VALID_POSES.stream().map(p -> org.bukkit.entity.Pose.values()[p.ordinal()]).toList()));
        }
        this.setPose0(internalPose, fixed);
    }

    public ResolvableProfile getProfile() {
        return new PaperResolvableProfile(this.getHandle().getProfile());
    }

    public void setProfile(ResolvableProfile profile) {
        Preconditions.checkArgument((profile != null ? 1 : 0) != 0, (Object)"profile cannot be null");
        this.getHandle().setProfile(((PaperResolvableProfile)profile).getHandle());
    }

    public SkinParts.Mutable getSkinParts() {
        return new PaperSkinParts.Mutable(this.getHandle().getEntityData().get(Avatar.DATA_PLAYER_MODE_CUSTOMISATION).byteValue());
    }

    public void setSkinParts(SkinParts parts) {
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (Object)"parts cannot be null");
        this.getHandle().getEntityData().set(Avatar.DATA_PLAYER_MODE_CUSTOMISATION, (byte)parts.getRaw());
    }

    public boolean isImmovable() {
        return this.getHandle().getImmovable();
    }

    public void setImmovable(boolean immovable) {
        this.getHandle().setImmovable(immovable);
    }

    public @Nullable Component getDescription() {
        return Optionull.map(this.getHandle().getDescription(), PaperAdventure::asAdventure);
    }

    public void setDescription(@Nullable Component description) {
        if (description == null) {
            this.getHandle().setHideDescription(true);
        } else {
            this.getHandle().setDescription(PaperAdventure.asVanilla(description));
            this.getHandle().setHideDescription(false);
        }
    }

    public MainHand getMainHand() {
        return this.getHandle().getMainArm() == HumanoidArm.LEFT ? MainHand.LEFT : MainHand.RIGHT;
    }

    public void setMainHand(MainHand hand) {
        Preconditions.checkArgument((hand != null ? 1 : 0) != 0, (Object)"hand cannot be null");
        this.getHandle().setMainArm(hand == MainHand.LEFT ? HumanoidArm.LEFT : HumanoidArm.RIGHT);
    }
}

