/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.util;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public abstract class CraftBlockInventoryConverter
implements CraftInventoryCreator.InventoryConverter {
    public abstract Container getBlockEntity();

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.getInventory(holder, type, this.getBlockEntity());
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
        Container blockEntity = this.getBlockEntity();
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            ((RandomizableContainerBlockEntity)blockEntity).name = PaperAdventure.asVanilla(title);
        }
        return this.getInventory(owner, type, blockEntity);
    }

    @Override
    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        Container blockEntity = this.getBlockEntity();
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            ((RandomizableContainerBlockEntity)blockEntity).name = CraftChatMessage.fromStringOrNull(title);
        }
        return this.getInventory(holder, type, blockEntity);
    }

    @Deprecated
    public Inventory getInventory(Container blockEntity) {
        return this.getInventory(null, null, blockEntity);
    }

    public Inventory getInventory(InventoryHolder owner, InventoryType type, Container blockEntity) {
        if (owner != null) {
            return new CraftInventoryCustom(owner, type, blockEntity);
        }
        return new CraftInventory(blockEntity);
    }

    public static class Crafter
    extends CraftBlockInventoryConverter {
        @Override
        public Container getBlockEntity() {
            return new CrafterBlockEntity(BlockPos.ZERO, Blocks.CRAFTER.defaultBlockState());
        }
    }

    public static class Smoker
    extends AbstractFurnaceInventoryConverter {
        @Override
        public Container getBlockEntity() {
            return new SmokerBlockEntity(BlockPos.ZERO, Blocks.SMOKER.defaultBlockState());
        }
    }

    public static class Lectern
    extends CraftBlockInventoryConverter {
        @Override
        public Container getBlockEntity() {
            return new LecternBlockEntity((BlockPos)BlockPos.ZERO, (BlockState)Blocks.LECTERN.defaultBlockState()).bookAccess;
        }
    }

    public static class BlastFurnace
    extends AbstractFurnaceInventoryConverter {
        @Override
        public Container getBlockEntity() {
            return new BlastFurnaceBlockEntity(BlockPos.ZERO, Blocks.BLAST_FURNACE.defaultBlockState());
        }
    }

    public static class Hopper
    extends CraftBlockInventoryConverter {
        @Override
        public Container getBlockEntity() {
            return new HopperBlockEntity(BlockPos.ZERO, Blocks.HOPPER.defaultBlockState());
        }
    }

    public static class Dropper
    extends CraftBlockInventoryConverter {
        @Override
        public Container getBlockEntity() {
            return new DropperBlockEntity(BlockPos.ZERO, Blocks.DROPPER.defaultBlockState());
        }
    }

    public static class Dispenser
    extends CraftBlockInventoryConverter {
        @Override
        public Container getBlockEntity() {
            return new DispenserBlockEntity(BlockPos.ZERO, Blocks.DISPENSER.defaultBlockState());
        }
    }

    public static class BrewingStand
    extends CraftBlockInventoryConverter {
        @Override
        public Container getBlockEntity() {
            return new BrewingStandBlockEntity(BlockPos.ZERO, Blocks.BREWING_STAND.defaultBlockState());
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
            Container blockEntity = this.getBlockEntity();
            if (blockEntity instanceof BrewingStandBlockEntity) {
                ((BrewingStandBlockEntity)blockEntity).name = PaperAdventure.asVanilla(title);
            }
            return this.getInventory(owner, type, blockEntity);
        }

        @Override
        public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
            Container blockEntity = this.getBlockEntity();
            if (blockEntity instanceof BrewingStandBlockEntity) {
                ((BrewingStandBlockEntity)blockEntity).name = CraftChatMessage.fromStringOrNull(title);
            }
            return this.getInventory(holder, type, blockEntity);
        }

        @Override
        public Inventory getInventory(Container blockEntity) {
            return this.getInventory(null, null, blockEntity);
        }

        @Override
        public Inventory getInventory(InventoryHolder owner, InventoryType type, Container blockEntity) {
            if (owner != null) {
                return new CraftInventoryCustom(owner, type, blockEntity);
            }
            return new CraftInventoryBrewer(blockEntity);
        }
    }

    public static abstract class AbstractFurnaceInventoryConverter
    extends CraftBlockInventoryConverter {
        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, Component title) {
            Container blockEntity = this.getBlockEntity();
            ((AbstractFurnaceBlockEntity)blockEntity).name = PaperAdventure.asVanilla(title);
            return this.getInventory(owner, type, blockEntity);
        }

        @Override
        public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
            Container blockEntity = this.getBlockEntity();
            ((AbstractFurnaceBlockEntity)blockEntity).name = CraftChatMessage.fromStringOrNull(title);
            return this.getInventory(owner, type, blockEntity);
        }

        @Override
        public Inventory getInventory(Container blockEntity) {
            return this.getInventory(null, null, blockEntity);
        }

        @Override
        public Inventory getInventory(InventoryHolder owner, InventoryType type, Container blockEntity) {
            if (owner != null) {
                return new CraftInventoryCustom(owner, type, blockEntity);
            }
            return new CraftInventoryFurnace((AbstractFurnaceBlockEntity)blockEntity);
        }
    }

    public static class Furnace
    extends AbstractFurnaceInventoryConverter {
        @Override
        public Container getBlockEntity() {
            FurnaceBlockEntity furnace = new FurnaceBlockEntity(BlockPos.ZERO, Blocks.FURNACE.defaultBlockState());
            return furnace;
        }
    }
}

