/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.view.builder;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.inventory.view.builder.CraftAbstractLocationInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;
import org.jspecify.annotations.Nullable;

public class CraftBlockEntityInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractLocationInventoryViewBuilder<V> {
    private final Block block;
    private final boolean useFakeBlockEntity;
    private final @Nullable CraftBlockInventoryBuilder builder;

    public CraftBlockEntityInventoryViewBuilder(MenuType<?> handle, Block block, @Nullable CraftBlockInventoryBuilder builder) {
        this(handle, block, builder, true);
    }

    public CraftBlockEntityInventoryViewBuilder(MenuType<?> handle, Block block, @Nullable CraftBlockInventoryBuilder builder, boolean useFakeBlockEntity) {
        super(handle);
        this.useFakeBlockEntity = useFakeBlockEntity;
        this.block = block;
        this.builder = builder;
    }

    @Override
    protected AbstractContainerMenu buildContainer(ServerPlayer player) {
        if (this.world == null) {
            this.world = player.level();
        }
        if (this.position == null) {
            this.position = player.blockPosition();
            return this.buildFakeBlockEntity(player);
        }
        BlockEntity entity = this.world.getBlockEntity(this.position);
        if (!(entity instanceof MenuConstructor)) {
            return this.buildFakeBlockEntity(player);
        }
        MenuConstructor container = (MenuConstructor)((Object)entity);
        AbstractContainerMenu atBlock = container.createMenu(player.nextContainerCounter(), player.getInventory(), player);
        if (atBlock.getType() != this.handle) {
            return this.buildFakeBlockEntity(player);
        }
        if (!(entity instanceof MenuProvider)) {
            throw new IllegalStateException("Provided blockEntity during MenuType creation can not find a default title! This is a bug!");
        }
        MenuProvider provider = (MenuProvider)((Object)entity);
        this.defaultTitle = provider.getDisplayName();
        return atBlock;
    }

    private AbstractContainerMenu buildFakeBlockEntity(ServerPlayer player) {
        MenuProvider inventory = this.builder.build(this.position, this.block.defaultBlockState());
        if (inventory instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)((Object)inventory);
            blockEntity.setLevel(this.world);
            this.defaultTitle = inventory.getDisplayName();
        }
        if (!this.useFakeBlockEntity) {
            return this.handle.create(player.nextContainerCounter(), player.getInventory());
        }
        return inventory.createMenu(player.nextContainerCounter(), player.getInventory(), player);
    }

    @Override
    public LocationInventoryViewBuilder<V> copy() {
        CraftBlockEntityInventoryViewBuilder<V> copy = new CraftBlockEntityInventoryViewBuilder<V>(this.handle, this.block, this.builder, this.useFakeBlockEntity);
        copy.world = this.world;
        copy.position = this.position;
        copy.checkReachable = this.checkReachable;
        copy.title = this.title;
        return copy;
    }

    public static interface CraftBlockInventoryBuilder {
        public MenuProvider build(BlockPos var1, BlockState var2);
    }
}

