/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.map.CraftMapCanvas;
import org.bukkit.craftbukkit.map.CraftMapRenderer;
import org.bukkit.craftbukkit.map.RenderData;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public final class CraftMapView
implements MapView {
    private final Map<CraftPlayer, RenderData> renderCache = new WeakHashMap<CraftPlayer, RenderData>();
    private final List<MapRenderer> renderers = new ArrayList<MapRenderer>();
    private final Map<MapRenderer, Map<CraftPlayer, CraftMapCanvas>> canvases = new HashMap<MapRenderer, Map<CraftPlayer, CraftMapCanvas>>();
    final MapItemSavedData worldMap;

    public CraftMapView(MapItemSavedData worldMap) {
        this.worldMap = worldMap;
        this.addRenderer(new CraftMapRenderer(worldMap));
    }

    public int getId() {
        return this.worldMap.id.id();
    }

    public boolean isVirtual() {
        return !this.renderers.isEmpty() && !(this.renderers.get(0) instanceof CraftMapRenderer);
    }

    public MapView.Scale getScale() {
        return MapView.Scale.valueOf((byte)this.worldMap.scale);
    }

    public void setScale(MapView.Scale scale) {
        this.worldMap.scale = scale.getValue();
    }

    public World getWorld() {
        ResourceKey<Level> dimension = this.worldMap.dimension;
        ServerLevel world = MinecraftServer.getServer().getLevel(dimension);
        if (world != null) {
            return world.getWorld();
        }
        if (this.worldMap.uniqueId != null) {
            return Bukkit.getServer().getWorld(this.worldMap.uniqueId);
        }
        return null;
    }

    public void setWorld(World world) {
        this.worldMap.dimension = ((CraftWorld)world).getHandle().dimension();
        this.worldMap.uniqueId = world.getUID();
    }

    public int getCenterX() {
        return this.worldMap.centerX;
    }

    public int getCenterZ() {
        return this.worldMap.centerZ;
    }

    public void setCenterX(int x) {
        this.worldMap.centerX = x;
    }

    public void setCenterZ(int z) {
        this.worldMap.centerZ = z;
    }

    public List<MapRenderer> getRenderers() {
        return new ArrayList<MapRenderer>(this.renderers);
    }

    public void addRenderer(MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            this.canvases.put(renderer, new WeakHashMap());
            renderer.initialize((MapView)this);
        }
    }

    public boolean removeRenderer(MapRenderer renderer) {
        if (this.renderers.contains(renderer)) {
            this.renderers.remove(renderer);
            for (Map.Entry<CraftPlayer, CraftMapCanvas> entry : this.canvases.get(renderer).entrySet()) {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        entry.getValue().setPixel(x, y, (byte)-1);
                    }
                }
            }
            this.canvases.remove(renderer);
            return true;
        }
        return false;
    }

    private boolean isContextual() {
        for (MapRenderer renderer : this.renderers) {
            if (!renderer.isContextual()) continue;
            return true;
        }
        return false;
    }

    public RenderData render(CraftPlayer player) {
        boolean context = this.isContextual();
        RenderData render = this.renderCache.get(context ? player : null);
        if (render == null) {
            render = new RenderData();
            this.renderCache.put(context ? player : null, render);
        }
        if (context && this.renderCache.containsKey(null)) {
            this.renderCache.remove(null);
        }
        Arrays.fill(render.buffer, (byte)0);
        render.cursors.clear();
        Iterator<MapRenderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            int i;
            MapRenderer renderer;
            CraftMapCanvas canvas = this.canvases.get(renderer).get((renderer = iterator.next()).isContextual() ? player : null);
            if (canvas == null) {
                canvas = new CraftMapCanvas(this);
                this.canvases.get(renderer).put(renderer.isContextual() ? player : null, canvas);
            }
            canvas.setBase(render.buffer);
            try {
                renderer.render((MapView)this, (MapCanvas)canvas, (Player)player);
            }
            catch (Throwable ex) {
                Bukkit.getLogger().log(java.util.logging.Level.SEVERE, "Could not render map using renderer " + renderer.getClass().getName(), ex);
            }
            byte[] buf = canvas.getBuffer();
            for (i = 0; i < buf.length; ++i) {
                byte color = buf[i];
                if (color < 0 && color > -9) continue;
                render.buffer[i] = color;
            }
            for (i = 0; i < canvas.getCursors().size(); ++i) {
                render.cursors.add(canvas.getCursors().getCursor(i));
            }
        }
        return render;
    }

    public boolean isTrackingPosition() {
        return this.worldMap.trackingPosition;
    }

    public void setTrackingPosition(boolean trackingPosition) {
        this.worldMap.trackingPosition = trackingPosition;
    }

    public boolean isUnlimitedTracking() {
        return this.worldMap.unlimitedTracking;
    }

    public void setUnlimitedTracking(boolean unlimited) {
        this.worldMap.unlimitedTracking = unlimited;
    }

    public boolean isLocked() {
        return this.worldMap.locked;
    }

    public void setLocked(boolean locked) {
        this.worldMap.locked = locked;
    }
}

