/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.persistence;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import io.papermc.paper.persistence.PaperPersistentDataContainerView;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftNBTTagConfigSerializer;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class CraftPersistentDataContainer
extends PaperPersistentDataContainerView
implements PersistentDataContainer {
    private final Map<String, Tag> customDataTags = new HashMap<String, Tag>();

    public CraftPersistentDataContainer(Map<String, Tag> customTags, CraftPersistentDataTypeRegistry registry) {
        this(registry);
        this.customDataTags.putAll(customTags);
    }

    public CraftPersistentDataContainer(CraftPersistentDataTypeRegistry registry) {
        super(registry);
    }

    @Override
    public Tag getTag(String key) {
        return this.customDataTags.get(key);
    }

    public <T, Z> void set(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"The NamespacedKey key cannot be null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"The provided type cannot be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"The provided value cannot be null");
        this.customDataTags.put(key.toString(), this.registry.wrap(type, type.toPrimitive(value, (PersistentDataAdapterContext)this.adapterContext)));
    }

    @Override
    @NotNull
    public Set<NamespacedKey> getKeys() {
        HashSet<NamespacedKey> keys = new HashSet<NamespacedKey>();
        this.customDataTags.keySet().forEach(key -> {
            String[] keyData = key.split(":", 2);
            if (keyData.length == 2) {
                keys.add(new NamespacedKey(keyData[0], keyData[1]));
            }
        });
        return keys;
    }

    public void remove(@NotNull NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"The NamespacedKey key cannot be null");
        this.customDataTags.remove(key.toString());
    }

    @Override
    public boolean isEmpty() {
        return this.customDataTags.isEmpty();
    }

    @Override
    @NotNull
    public void copyTo(PersistentDataContainer other, boolean replace) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0, (Object)"The target container cannot be null");
        CraftPersistentDataContainer target = (CraftPersistentDataContainer)other;
        if (replace) {
            target.customDataTags.putAll(this.customDataTags);
        } else {
            this.customDataTags.forEach(target.customDataTags::putIfAbsent);
        }
    }

    @Override
    public PersistentDataAdapterContext getAdapterContext() {
        return this.adapterContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftPersistentDataContainer)) {
            return false;
        }
        Map<String, Tag> myRawMap = this.getRaw();
        Map<String, Tag> theirRawMap = ((CraftPersistentDataContainer)obj).getRaw();
        return Objects.equals(myRawMap, theirRawMap);
    }

    @Override
    public CompoundTag toTagCompound() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, Tag> entry : this.customDataTags.entrySet()) {
            tag.put(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    public void put(String key, Tag base) {
        this.customDataTags.put(key, base);
    }

    public void putAll(Map<String, Tag> map) {
        this.customDataTags.putAll(map);
    }

    public void putAll(CompoundTag compound) {
        for (String key : compound.keySet()) {
            this.customDataTags.put(key, compound.get(key));
        }
    }

    public Map<String, Tag> getRaw() {
        return this.customDataTags;
    }

    public CraftPersistentDataTypeRegistry getDataTagTypeRegistry() {
        return this.registry;
    }

    public int hashCode() {
        int hashCode = 3;
        return hashCode += this.customDataTags.hashCode();
    }

    public String serialize() {
        return CraftNBTTagConfigSerializer.serialize(this.toTagCompound());
    }

    public void clear() {
        this.customDataTags.clear();
    }

    public void readFromBytes(byte[] bytes, boolean clear) throws IOException {
        if (clear) {
            this.clear();
        }
        try (DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(bytes));){
            CompoundTag compound = NbtIo.read(dataInput);
            this.putAll(compound);
        }
    }

    public Map<String, Tag> getTagsCloned() {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        this.customDataTags.forEach((key, tag) -> tags.put((String)key, tag.copy()));
        return tags;
    }

    public static Codec<CraftPersistentDataContainer> createCodec(CraftPersistentDataTypeRegistry registry) {
        return CompoundTag.CODEC.xmap(tag -> {
            CraftPersistentDataContainer container = new CraftPersistentDataContainer(registry);
            container.putAll((CompoundTag)tag);
            return container;
        }, CraftPersistentDataContainer::toTagCompound);
    }

    public int getSize() {
        return this.customDataTags.size();
    }
}

