/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.potion;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.papermc.paper.util.Holderable;
import io.papermc.paper.world.flag.PaperFeatureDependent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.potion.CraftPotionEffectTypeCategory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionEffectTypeCategory;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftPotionEffectType
extends PotionEffectType
implements Holderable<MobEffect>,
PaperFeatureDependent<MobEffect> {
    private final Holder<MobEffect> holder;
    private final Supplier<Integer> id;

    public static PotionEffectType minecraftHolderToBukkit(Holder<MobEffect> minecraft) {
        return CraftPotionEffectType.minecraftToBukkit(minecraft.value());
    }

    public static PotionEffectType minecraftToBukkit(MobEffect minecraft) {
        return (PotionEffectType)CraftRegistry.minecraftToBukkit(minecraft, Registries.MOB_EFFECT);
    }

    public static MobEffect bukkitToMinecraft(PotionEffectType bukkit) {
        return (MobEffect)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<MobEffect> bukkitToMinecraftHolder(PotionEffectType bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit);
    }

    public CraftPotionEffectType(Holder<MobEffect> holder) {
        this.holder = holder;
        this.id = Suppliers.memoize(() -> CraftRegistry.getMinecraftRegistry(Registries.MOB_EFFECT).getId((MobEffect)this.getHandle()) + 1);
    }

    @Override
    public Holder<MobEffect> getHolder() {
        return this.holder;
    }

    @Override
    public NamespacedKey getKey() {
        return PaperFeatureDependent.super.getKey();
    }

    public double getDurationModifier() {
        return 1.0;
    }

    public int getId() {
        return this.id.get();
    }

    public String getName() {
        return switch (this.getId()) {
            case 1 -> "SPEED";
            case 2 -> "SLOW";
            case 3 -> "FAST_DIGGING";
            case 4 -> "SLOW_DIGGING";
            case 5 -> "INCREASE_DAMAGE";
            case 6 -> "HEAL";
            case 7 -> "HARM";
            case 8 -> "JUMP";
            case 9 -> "CONFUSION";
            case 10 -> "REGENERATION";
            case 11 -> "DAMAGE_RESISTANCE";
            case 12 -> "FIRE_RESISTANCE";
            case 13 -> "WATER_BREATHING";
            case 14 -> "INVISIBILITY";
            case 15 -> "BLINDNESS";
            case 16 -> "NIGHT_VISION";
            case 17 -> "HUNGER";
            case 18 -> "WEAKNESS";
            case 19 -> "POISON";
            case 20 -> "WITHER";
            case 21 -> "HEALTH_BOOST";
            case 22 -> "ABSORPTION";
            case 23 -> "SATURATION";
            case 24 -> "GLOWING";
            case 25 -> "LEVITATION";
            case 26 -> "LUCK";
            case 27 -> "UNLUCK";
            case 28 -> "SLOW_FALLING";
            case 29 -> "CONDUIT_POWER";
            case 30 -> "DOLPHINS_GRACE";
            case 31 -> "BAD_OMEN";
            case 32 -> "HERO_OF_THE_VILLAGE";
            case 33 -> "DARKNESS";
            default -> this.getKey().toString();
        };
    }

    public PotionEffect createEffect(int duration, int amplifier) {
        return new PotionEffect((PotionEffectType)this, this.isInstant() ? 1 : (int)((double)duration * this.getDurationModifier()), amplifier);
    }

    public boolean isInstant() {
        return ((MobEffect)this.getHandle()).isInstantenous();
    }

    public PotionEffectTypeCategory getCategory() {
        return CraftPotionEffectTypeCategory.minecraftToBukkit(((MobEffect)this.getHandle()).getCategory());
    }

    public Color getColor() {
        return Color.fromRGB((int)((MobEffect)this.getHandle()).getColor());
    }

    public String getTranslationKey() {
        return ((MobEffect)this.getHandle()).getDescriptionId();
    }

    public Map<Attribute, AttributeModifier> getEffectAttributes() {
        HashMap attributeMap = new HashMap();
        ((MobEffect)this.getHandle()).attributeModifiers.forEach((attribute, attributeModifier) -> attributeMap.put(CraftAttribute.minecraftHolderToBukkit(attribute), CraftAttributeInstance.convert(attributeModifier.create(0))));
        return Map.copyOf(attributeMap);
    }

    public double getAttributeModifierAmount(Attribute attribute, int effectAmplifier) {
        Preconditions.checkArgument((effectAmplifier >= 0 ? 1 : 0) != 0, (Object)"effectAmplifier must be greater than or equal to 0");
        Holder<net.minecraft.world.entity.ai.attributes.Attribute> nmsAttribute = CraftAttribute.bukkitToMinecraftHolder(attribute);
        Preconditions.checkArgument((boolean)((MobEffect)this.getHandle()).attributeModifiers.containsKey(nmsAttribute), (Object)(String.valueOf(attribute) + " is not present on " + String.valueOf(this.getKey())));
        return ((MobEffect)this.getHandle()).attributeModifiers.get(nmsAttribute).create(effectAmplifier).amount();
    }

    public PotionEffectType.Category getEffectCategory() {
        return CraftPotionEffectType.fromNMS(((MobEffect)this.getHandle()).getCategory());
    }

    public String translationKey() {
        return ((MobEffect)this.getHandle()).getDescriptionId();
    }

    public static PotionEffectType.Category fromNMS(MobEffectCategory mobEffectInfo) {
        return switch (mobEffectInfo) {
            default -> throw new MatchException(null, null);
            case MobEffectCategory.BENEFICIAL -> PotionEffectType.Category.BENEFICIAL;
            case MobEffectCategory.HARMFUL -> PotionEffectType.Category.HARMFUL;
            case MobEffectCategory.NEUTRAL -> PotionEffectType.Category.NEUTRAL;
        };
    }

    public boolean equals(Object other) {
        return PaperFeatureDependent.super.implEquals(other);
    }

    public int hashCode() {
        return PaperFeatureDependent.super.implHashCode();
    }

    public String toString() {
        return PaperFeatureDependent.super.implToString();
    }
}

