/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.spawner;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.storage.TagValueOutput;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.spawner.Spawner;
import org.slf4j.Logger;

public interface PaperSharedSpawnerLogic
extends Spawner {
    public static final Logger LOGGER = LogUtils.getLogger();

    public BaseSpawner getSpawner();

    public Level getInternalWorld();

    public RegistryAccess getRegistryAccess();

    public BlockPos getInternalPosition();

    default public boolean isActivated() {
        return this.getSpawner().isNearPlayer(this.getInternalWorld(), this.getInternalPosition());
    }

    default public void resetTimer() {
        this.getSpawner().delay(this.getInternalWorld(), this.getInternalPosition());
    }

    default public void setNextSpawnData(SpawnData spawnData) {
        this.getSpawner().setNextSpawnData(this.getInternalWorld(), this.getInternalPosition(), spawnData);
    }

    default public void setSpawnedItem(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null && !itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"spawners cannot spawn air");
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy(itemStack);
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(() -> this.getSpawner().toString(), LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext(scopedCollector, this.getInternalWorld().registryAccess());
            tagValueOutput.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(EntityType.ITEM).toString());
            tagValueOutput.store("Item", net.minecraft.world.item.ItemStack.CODEC, item);
            this.setNextSpawnData(new SpawnData(tagValueOutput.buildResult(), Optional.empty(), Optional.ofNullable(this.getSpawner().nextSpawnData).flatMap(SpawnData::equipment)));
        }
    }
}

