/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import org.jetbrains.annotations.NotNull;

public class CraftNBTTagConfigSerializer {
    private static final Pattern ARRAY = Pattern.compile("^\\[.*]");
    private static final Pattern INTEGER = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)i", 2);
    private static final Pattern DOUBLE = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final TagParser<Tag> MOJANGSON_PARSER = TagParser.create(NbtOps.INSTANCE);

    public static String serialize(@NotNull Tag tag) {
        SnbtPrinterTagVisitor snbtVisitor = new SnbtPrinterTagVisitor();
        return snbtVisitor.visit(tag);
    }

    public static Tag deserialize(Object object) {
        if (object instanceof String) {
            String snbtString = (String)object;
            try {
                return TagParser.parseCompoundFully(snbtString);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException("Failed to deserialise nbt", e);
            }
        }
        return CraftNBTTagConfigSerializer.internalLegacyDeserialization(object);
    }

    private static Tag internalLegacyDeserialization(@NotNull Object object) {
        if (object instanceof Map) {
            CompoundTag compound = new CompoundTag();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                compound.put((String)entry.getKey(), CraftNBTTagConfigSerializer.internalLegacyDeserialization(entry.getValue()));
            }
            return compound;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return new ListTag();
            }
            ListTag tagList = new ListTag();
            for (Object tag : list) {
                tagList.add(CraftNBTTagConfigSerializer.internalLegacyDeserialization(tag));
            }
            return tagList;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (ARRAY.matcher(string).matches()) {
                try {
                    return MOJANGSON_PARSER.parseAsArgument(new StringReader(string));
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException("Could not deserialize found list ", e);
                }
            }
            if (INTEGER.matcher(string).matches()) {
                return IntTag.valueOf(Integer.parseInt(string.substring(0, string.length() - 1)));
            }
            if (DOUBLE.matcher(string).matches()) {
                return DoubleTag.valueOf(Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            try {
                Tag tag = MOJANGSON_PARSER.parseAsArgument(new StringReader(string));
                if (tag instanceof IntTag) {
                    return StringTag.valueOf(tag.toString());
                }
                if (tag instanceof DoubleTag) {
                    return StringTag.valueOf(String.valueOf(((DoubleTag)tag).doubleValue()));
                }
                if (tag instanceof StringTag) {
                    return StringTag.valueOf(string);
                }
                return tag;
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new RuntimeException("Could not deserialize found primitive ", commandSyntaxException);
            }
        }
        throw new RuntimeException("Could not deserialize Tag");
    }
}

