/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import com.mojang.logging.LogUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;

public final class WorldUUID {
    private static final Logger LOGGER = LogUtils.getLogger();

    private WorldUUID() {
    }

    public static UUID getOrCreate(File worldDir) {
        File fileId = new File(worldDir, "uid.dat");
        if (fileId.exists()) {
            UUID uUID;
            DataInputStream inputStream = new DataInputStream(new FileInputStream(fileId));
            try {
                uUID = new UUID(inputStream.readLong(), inputStream.readLong());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to read {}, generating new random UUID", (Object)fileId, (Object)ex);
                }
            }
            inputStream.close();
            return uUID;
        }
        UUID uuid = UUID.randomUUID();
        try (DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(fileId));){
            outputStream.writeLong(uuid.getMostSignificantBits());
            outputStream.writeLong(uuid.getLeastSignificantBits());
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to write {}", (Object)fileId, (Object)ex);
        }
        return uuid;
    }
}

