/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util.permissions;

import net.minecraft.world.level.GameType;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.permissions.DefaultPermissions;

public final class CommandPermissions {
    private static final String ROOT = "minecraft.command";
    private static final String PREFIX = "minecraft.command.";

    private CommandPermissions() {
    }

    public static Permission registerPermissions(Permission parent) {
        Permission commands = DefaultPermissions.registerPermission((String)ROOT, (String)"Gives the user the ability to use all vanilla minecraft commands", (Permission)parent);
        DefaultPermissions.registerPermission((String)"minecraft.command.kill", (String)"Allows the user to commit suicide", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.me", (String)"Allows the user to perform a chat action", (PermissionDefault)PermissionDefault.TRUE, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.msg", (String)"Allows the user to privately message another player", (PermissionDefault)PermissionDefault.TRUE, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.help", (String)"Allows the user to access Vanilla command help", (PermissionDefault)PermissionDefault.TRUE, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.say", (String)"Allows the user to talk as the console", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.give", (String)"Allows the user to give items to players", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.teleport", (String)"Allows the user to teleport players", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.kick", (String)"Allows the user to kick players", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.stop", (String)"Allows the user to stop the server", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.list", (String)"Allows the user to list all online players", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        Permission gamemodeVanilla = DefaultPermissions.registerPermission((String)"minecraft.command.gamemode", (String)"Allows the user to change the gamemode", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        for (GameType gametype : GameType.values()) {
            Permission gamemodeSelf = DefaultPermissions.registerPermission((String)("minecraft.command.gamemode." + gametype.getName()), (String)("Allows the user to set " + gametype.getName() + " gamemode for self"), (PermissionDefault)PermissionDefault.OP);
            Permission gamemodeOther = DefaultPermissions.registerPermission((String)("minecraft.command.gamemode." + gametype.getName() + ".other"), (String)("Allows the user to set " + gametype.getName() + " gamemode for other players"), (PermissionDefault)PermissionDefault.OP);
            gamemodeSelf.addParent(gamemodeOther, true);
            gamemodeVanilla.addParent(gamemodeSelf, true);
        }
        DefaultPermissions.registerPermission((String)"minecraft.command.experience", (String)"Allows the user to give themselves or others arbitrary values of experience", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.defaultgamemode", (String)"Allows the user to change the default gamemode of the server", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.seed", (String)"Allows the user to view the seed of the world", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.effect", (String)"Allows the user to add/remove effects on players", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.selector", (String)"Allows the use of selectors", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.trigger", (String)"Allows the use of the trigger command", (PermissionDefault)PermissionDefault.TRUE, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.advancement", (String)"Allows the user to give, remove, or check player advancements", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.attribute", (String)"Allows the user to query, add, remove or set an entity attribute", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.ban", (String)"Allows the user to add players to the ban list", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.ban-ip", (String)"Allows the user to add ip address to the ban list", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.banlist", (String)"Allows the user to display the ban list", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.bossbar", (String)"Allows the user to create and modify bossbars", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.clear", (String)"Allows the user to clear items from player inventory", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.clone", (String)"Allows the user to copy blocks from one place to another", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.damage", (String)"Allows the user to use the damage command to damage entities", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.data", (String)"Allows the user to get, merge, modify, and remove block entity and entity NBT data", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.datapack", (String)"Allows the user to control loaded data packs", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.debug", (String)"Allows the user to start or stop a debugging session", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.deop", (String)"Allows the user to revoke operator status from a player", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.dialog", (String)"Allows the user to show dialogs", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.difficulty", (String)"Allows the user to set the difficulty level", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.enchant", (String)"Allows the user to enchant a player item", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.execute", (String)"Allows the user to execute another command", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.fetchprofile", (String)"Allows the user to fetch a player profile via name or id", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.fill", (String)"Allows the user to fill a region with a specific block", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.fillbiome", (String)"Allows the user to fill a region with a specific biome", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.forceload", (String)"Allows the user to force chunks to be constantly loaded or not", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.function", (String)"Allows the user to run a function", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.gamerule", (String)"Allows a user to set or query a game rule value", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.item", (String)"Allows the user to replace items in inventories", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.jfr", (String)"Allows a user to use the vanilla Java FlightRecorder profiling system", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.locate", (String)"Allows the user to locate the closest structure", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.loot", (String)"Allows the user to drop items from an inventory slot onto the ground", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.op", (String)"Allows the user to grant operator status to a player", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.pardon", (String)"Allows the user to remove entries from the player ban list", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.pardon-ip", (String)"Allows the user to remove entries from the ip address ban list", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.particle", (String)"Allows the user to create particles", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.perf", (String)"Allows the user to start/stop the vanilla performance metrics capture", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.place", (String)"Allows the user to place features and structures", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.playsound", (String)"Allows the user to play a sound", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.random", (String)"Allows the user to generate a random number", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.recipe", (String)"Allows the user to give or take recipes", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.reload", (String)"Allows the user to reload loot tables, advancements, and functions from disk", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.return", (String)"Allows the user to use the /return command", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.ride", (String)"Allows the user to use the /ride command to control passengers", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.rotate", (String)"Allows the user to change the rotation of entities", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.save-all", (String)"Allows the user to save the server to disk", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.save-off", (String)"Allows the user disable automatic server saves", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.save-on", (String)"Allows the user enable automatic server saves", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.schedule", (String)"Allows the user to delay the execution of a function", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.scoreboard", (String)"Allows the user manage scoreboard objectives and players", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.setblock", (String)"Allows the user to change a block to another block", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.setidletimeout", (String)"Allows the user to set the time before idle players are kicked", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.setworldspawn", (String)"Allows the user to set the world spawn", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.spawnpoint", (String)"Allows the user to set the spawn point for a player", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.spectate", (String)"Allows the user to make one player in spectator mode spectate an entity", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.spreadplayers", (String)"Allows the user to teleport entities to random locations", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.stopsound", (String)"Allows the user to stop a sound", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.summon", (String)"Allows the user to summon an entity", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.tag", (String)"Allows the user to control entity tags", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.team", (String)"Allows the user to control teams", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.teammsg", (String)"Allows the user to specify the message to send to team", (PermissionDefault)PermissionDefault.TRUE, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.tellraw", (String)"Allows the user to display a JSON message to players", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.test", (String)"Allows the user to manage and execute GameTests", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.tick", (String)"Allows the user to control the tick rate of the server", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.time", (String)"Allows the user to change or query the world's game time", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.title", (String)"Allows the user to manage screen titles", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.transfer", (String)"Allows the user to transfer to another server", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.version", (String)"Shows info related to the server version", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.waypoint", (String)"Allows the management of a waypoints on the server/locator bar", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.weather", (String)"Allows the user to set the weather", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.whitelist", (String)"Allows the user to manage the server whitelist", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.command.worldborder", (String)"Allows the user to manage the world border", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        DefaultPermissions.registerPermission((String)"minecraft.admin.command_feedback", (String)"Receive command broadcasts when sendCommandFeedback is true", (PermissionDefault)PermissionDefault.OP, (Permission)commands);
        commands.recalculatePermissibles();
        return commands;
    }
}

