/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import org.purpurmc.purpur.PurpurConfig;

public class PingCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("ping").requires(listener -> listener.hasPermission(2, "bukkit.command.ping"))).executes(context -> PingCommand.execute((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).requires(listener -> listener.hasPermission(2, "bukkit.command.ping.other"))).executes(context -> PingCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"))))));
    }

    private static int execute(CommandSourceStack sender, Collection<ServerPlayer> targets) {
        for (ServerPlayer player : targets) {
            String output = String.format(PurpurConfig.pingCommandOutput, player.getGameProfile().name(), player.connection.latency());
            sender.sendSuccess(output, false);
        }
        return targets.size();
    }
}

