/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.controller;

import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.player.Player;

public class LookControllerWASD
extends LookControl {
    protected final Mob entity;
    private float yOffset = 0.0f;
    private float xOffset = 0.0f;

    public LookControllerWASD(Mob entity) {
        super(entity);
        this.entity = entity;
    }

    @Override
    public void tick() {
        if (this.entity.getRider() != null && this.entity.isControllable()) {
            this.purpurTick(this.entity.getRider());
        } else {
            this.vanillaTick();
        }
    }

    protected void purpurTick(Player rider) {
        this.setYawPitch(rider.getYRot(), rider.getXRot());
    }

    public void vanillaTick() {
        super.tick();
    }

    public void setYawPitch(float yRot, float xRot) {
        this.entity.setXRot(this.normalizePitch(xRot + this.xOffset));
        this.entity.setYRot(this.normalizeYaw(yRot + this.yOffset));
        this.entity.setYHeadRot(this.entity.getYRot());
        this.entity.xRotO = this.entity.getXRot();
        this.entity.yRotO = this.entity.getYRot();
        ClientboundMoveEntityPacket.PosRot entityPacket = new ClientboundMoveEntityPacket.PosRot(this.entity.getId(), 0, 0, 0, (byte)Mth.floor(this.entity.getYRot() * 256.0f / 360.0f), (byte)Mth.floor(this.entity.getXRot() * 256.0f / 360.0f), this.entity.onGround);
        ((ServerLevel)this.entity.level()).getChunkSource().sendToTrackingPlayers(this.entity, entityPacket);
    }

    public void setOffsets(float yaw, float pitch) {
        this.yOffset = yaw;
        this.xOffset = pitch;
    }

    public float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) >= 180.0f) {
            yaw -= 360.0f;
        } else if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    public float normalizePitch(float pitch) {
        if (pitch > 90.0f) {
            pitch = 90.0f;
        } else if (pitch < -90.0f) {
            pitch = -90.0f;
        }
        return pitch;
    }
}

