/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.controller;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.Player;
import org.bukkit.entity.Entity;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.event.entity.RidableSpacebarEvent;

public class MoveControllerWASD
extends MoveControl {
    protected final Mob entity;
    private final double speedModifier;

    public MoveControllerWASD(Mob entity) {
        this(entity, 1.0);
    }

    public MoveControllerWASD(Mob entity, double speedModifier) {
        super(entity);
        this.entity = entity;
        this.speedModifier = speedModifier;
    }

    @Override
    public boolean hasWanted() {
        return this.entity.getRider() != null ? this.strafeForwards != 0.0f || this.strafeRight != 0.0f : super.hasWanted();
    }

    @Override
    public void tick() {
        if (this.entity.getRider() != null && this.entity.isControllable()) {
            this.purpurTick(this.entity.getRider());
        } else {
            this.vanillaTick();
        }
    }

    public void vanillaTick() {
        super.tick();
    }

    public void purpurTick(Player rider) {
        Input lastClientInput = ((ServerPlayer)rider).getLastClientInput();
        float forward = (lastClientInput.forward() == lastClientInput.backward() ? 0.0f : (lastClientInput.forward() ? 1.0f : -1.0f)) * 0.5f;
        float strafe = (lastClientInput.left() == lastClientInput.right() ? 0.0f : (lastClientInput.left() ? 1.0f : -1.0f)) * 0.25f;
        if (forward <= 0.0f) {
            forward *= 0.5f;
        }
        float yawOffset = 0.0f;
        if (strafe != 0.0f) {
            if (forward == 0.0f) {
                yawOffset += strafe > 0.0f ? -90.0f : 90.0f;
                forward = Math.abs(strafe * 2.0f);
            } else {
                yawOffset += strafe > 0.0f ? -30.0f : 30.0f;
                strafe /= 2.0f;
                if (forward < 0.0f) {
                    yawOffset += strafe > 0.0f ? -110.0f : 110.0f;
                    forward *= -1.0f;
                }
            }
        } else if (forward < 0.0f) {
            yawOffset -= 180.0f;
            forward *= -1.0f;
        }
        ((LookControllerWASD)this.entity.getLookControl()).setOffsets(yawOffset, 0.0f);
        if (lastClientInput.jump() && MoveControllerWASD.spacebarEvent(this.entity) && !this.entity.onSpacebar() && this.entity.onGround) {
            this.entity.jumpFromGround();
        }
        this.setSpeedModifier(this.entity.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedModifier);
        this.entity.setSpeed((float)this.getSpeedModifier());
        this.entity.setForwardMot(forward);
        this.setForward(this.entity.getForwardMot());
        this.setStrafe(this.entity.getStrafeMot());
    }

    public static boolean spacebarEvent(Mob entity) {
        if (RidableSpacebarEvent.getHandlerList().getRegisteredListeners().length > 0) {
            return new RidableSpacebarEvent((Entity)entity.getBukkitEntity()).callEvent();
        }
        return true;
    }
}

