/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.entity;

import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.purpurmc.purpur.entity.StoredEntity;
import org.slf4j.Logger;

public class PurpurStoredBee
implements StoredEntity<Bee> {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private final EntityBlockStorage<Bee> blockStorage;
    private final BeehiveBlockEntity.BeeData handle;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private net.kyori.adventure.text.Component customName;

    public PurpurStoredBee(BeehiveBlockEntity.BeeData data, EntityBlockStorage<Bee> blockStorage, BeehiveBlockEntity blockEntity) {
        this.handle = data;
        this.blockStorage = blockStorage;
        CompoundTag customData = this.handle.occupant.entityData().copyTagWithEntityId();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), LOGGER);){
            ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)RegistryAccess.EMPTY, customData);
            Component customNameMinecraft = BlockEntity.parseCustomNameSafe(valueInput, "CustomName");
            this.customName = customNameMinecraft == null ? null : PaperAdventure.asAdventure(customNameMinecraft);
            Tag tag = customData.get("BukkitValues");
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                this.persistentDataContainer.putAll(compoundTag);
            }
        }
    }

    public BeehiveBlockEntity.BeeData getHandle() {
        return this.handle;
    }

    @Nullable
    public net.kyori.adventure.text.Component customName() {
        return this.customName;
    }

    public void customName(@Nullable net.kyori.adventure.text.Component customName) {
        this.customName = customName;
    }

    @Nullable
    public String getCustomName() {
        return PaperAdventure.asPlain(this.customName, Locale.US);
    }

    public void setCustomName(@Nullable String name) {
        this.customName((net.kyori.adventure.text.Component)(name != null ? net.kyori.adventure.text.Component.text((String)name) : null));
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public boolean hasBeenReleased() {
        return !this.blockStorage.getEntities().contains(this);
    }

    @Nullable
    public Bee release() {
        return (Bee)this.blockStorage.releaseEntity((StoredEntity)this);
    }

    @Nullable
    public EntityBlockStorage<Bee> getBlockStorage() {
        if (this.hasBeenReleased()) {
            return null;
        }
        return this.blockStorage;
    }

    @NotNull
    public EntityType getType() {
        return EntityType.BEE;
    }

    public void update() {
        this.handle.occupant.entityData().copyTagWithEntityId().put("BukkitValues", this.persistentDataContainer.toTagCompound());
        if (this.customName == null) {
            this.handle.occupant.entityData().copyTagWithEntityId().remove("CustomName");
        } else {
            this.handle.occupant.entityData().copyTagWithEntityId().putString("CustomName", CraftChatMessage.toJSON(PaperAdventure.asVanilla(this.customName)));
        }
    }
}

