/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.item;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SpawnerItem
extends BlockItem {
    public SpawnerItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    @Override
    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        BlockEntity blockEntity;
        boolean handled = super.updateCustomBlockEntityTag(pos, level, player, stack, state);
        if (level.purpurConfig.silkTouchEnabled && player.getBukkitEntity().hasPermission("purpur.place.spawners") && (blockEntity = level.getBlockEntity(pos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
            CompoundTag customData = stack.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY).copyTag();
            Optional<String> mobTypeStringOptional = customData.getString("Purpur.mob_type");
            if (mobTypeStringOptional.isPresent()) {
                EntityType.byString(mobTypeStringOptional.get()).ifPresent(type -> spawner.getSpawner().setEntityId((EntityType<?>)type, level, level.random, pos));
            } else if (customData.contains("Purpur.SpawnData")) {
                customData.getCompound("Purpur.SpawnData").flatMap(spawnerData -> spawnerData.read("SpawnData", SpawnData.CODEC)).ifPresent(spawnData -> {
                    spawner.getSpawner().nextSpawnData = spawnData;
                });
            }
        }
        return handled;
    }
}

