/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.purpurmc.purpur.task.CompassTask;
import org.purpurmc.purpur.task.RamBarTask;
import org.purpurmc.purpur.task.TPSBarTask;
import org.purpurmc.purpur.util.MinecraftInternalPlugin;

public abstract class BossBarTask
extends BukkitRunnable {
    private final Map<UUID, BossBar> bossbars = new HashMap<UUID, BossBar>();
    private boolean started;

    abstract BossBar createBossBar();

    abstract void updateBossBar(BossBar var1, Player var2);

    public void run() {
        Iterator<Map.Entry<UUID, BossBar>> iter = this.bossbars.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<UUID, BossBar> entry = iter.next();
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null) {
                iter.remove();
                continue;
            }
            this.updateBossBar(entry.getValue(), player);
        }
    }

    public void cancel() {
        super.cancel();
        new HashSet<UUID>(this.bossbars.keySet()).forEach(uuid -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                this.removePlayer(player);
            }
        });
        this.bossbars.clear();
    }

    public boolean removePlayer(Player player) {
        BossBar bossbar = this.bossbars.remove(player.getUniqueId());
        if (bossbar != null) {
            player.hideBossBar(bossbar);
            return true;
        }
        return false;
    }

    public void addPlayer(Player player) {
        this.removePlayer(player);
        BossBar bossbar = this.createBossBar();
        this.bossbars.put(player.getUniqueId(), bossbar);
        this.updateBossBar(bossbar, player);
        player.showBossBar(bossbar);
    }

    public boolean hasPlayer(UUID uuid) {
        return this.bossbars.containsKey(uuid);
    }

    public boolean togglePlayer(Player player) {
        if (this.removePlayer(player)) {
            return false;
        }
        this.addPlayer(player);
        return true;
    }

    public void start() {
        this.stop();
        this.runTaskTimerAsynchronously((Plugin)new MinecraftInternalPlugin(), 1L, 1L);
        this.started = true;
    }

    public void stop() {
        if (this.started) {
            this.cancel();
        }
    }

    public static void startAll() {
        RamBarTask.instance().start();
        TPSBarTask.instance().start();
        CompassTask.instance().start();
    }

    public static void stopAll() {
        RamBarTask.instance().stop();
        TPSBarTask.instance().stop();
        CompassTask.instance().stop();
    }

    public static void addToAll(ServerPlayer player) {
        CraftPlayer bukkit = player.getBukkitEntity();
        if (player.ramBar()) {
            RamBarTask.instance().addPlayer(bukkit);
        }
        if (player.tpsBar()) {
            TPSBarTask.instance().addPlayer(bukkit);
        }
        if (player.compassBar()) {
            CompassTask.instance().addPlayer(bukkit);
        }
    }

    public static void removeFromAll(Player player) {
        RamBarTask.instance().removePlayer(player);
        TPSBarTask.instance().removePlayer(player);
        CompassTask.instance().removePlayer(player);
    }
}

