/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.task;

import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Items;
import org.bukkit.entity.Player;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.task.BossBarTask;

public class CompassTask
extends BossBarTask {
    private static CompassTask instance;
    private int tick = 0;

    public static CompassTask instance() {
        if (instance == null) {
            instance = new CompassTask();
        }
        return instance;
    }

    @Override
    public void run() {
        if (++this.tick < PurpurConfig.commandCompassBarTickInterval) {
            return;
        }
        this.tick = 0;
        MinecraftServer.getServer().getAllLevels().forEach(level -> {
            if (level.purpurConfig.compassItemShowsBossBar) {
                level.players().forEach(player -> {
                    if (!player.compassBar()) {
                        if (player.getMainHandItem().getItem() != Items.COMPASS && player.getOffhandItem().getItem() != Items.COMPASS) {
                            this.removePlayer(player.getBukkitEntity());
                        } else if (!this.hasPlayer(player.getUUID())) {
                            this.addPlayer(player.getBukkitEntity());
                        }
                    }
                });
            }
        });
        super.run();
    }

    @Override
    BossBar createBossBar() {
        return BossBar.bossBar((Component)Component.text((String)""), (float)PurpurConfig.commandCompassBarProgressPercent, (BossBar.Color)PurpurConfig.commandCompassBarProgressColor, (BossBar.Overlay)PurpurConfig.commandCompassBarProgressOverlay);
    }

    @Override
    void updateBossBar(BossBar bossbar, Player player) {
        float yaw = player.getLocation().getYaw();
        int length = PurpurConfig.commandCompassBarTitle.length();
        int pos = (int)(this.normalize(yaw) * ((float)length / 720.0f) + (float)length / 2.0f);
        bossbar.name((Component)Component.text((String)PurpurConfig.commandCompassBarTitle.substring(pos - 25, pos + 25)));
    }

    private float normalize(float yaw) {
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw > 180.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }
}

