/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.task;

import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.task.BossBarTask;

public class TPSBarTask
extends BossBarTask {
    private static TPSBarTask instance;
    private double tps = 20.0;
    private double mspt = 0.0;
    private int tick = 0;

    public static TPSBarTask instance() {
        if (instance == null) {
            instance = new TPSBarTask();
        }
        return instance;
    }

    @Override
    BossBar createBossBar() {
        return BossBar.bossBar((Component)Component.text((String)""), (float)0.0f, (BossBar.Color)TPSBarTask.instance().getBossBarColor(), (BossBar.Overlay)PurpurConfig.commandTPSBarProgressOverlay);
    }

    @Override
    void updateBossBar(BossBar bossbar, Player player) {
        bossbar.progress(this.getBossBarProgress());
        bossbar.color(this.getBossBarColor());
        bossbar.name(MiniMessage.miniMessage().deserialize(PurpurConfig.commandTPSBarTitle, new TagResolver[]{Placeholder.component((String)"tps", (ComponentLike)this.getTPSColor()), Placeholder.component((String)"mspt", (ComponentLike)this.getMSPTColor()), Placeholder.component((String)"ping", (ComponentLike)this.getPingColor(player.getPing()))}));
    }

    @Override
    public void run() {
        if (++this.tick < PurpurConfig.commandTPSBarTickInterval) {
            return;
        }
        this.tick = 0;
        this.tps = Math.max(Math.min(Bukkit.getTPS()[0], 20.0), 0.0);
        this.mspt = Bukkit.getAverageTickTime();
        super.run();
    }

    private float getBossBarProgress() {
        if (PurpurConfig.commandTPSBarProgressFillMode == FillMode.MSPT) {
            return Math.max(Math.min((float)this.mspt / 50.0f, 1.0f), 0.0f);
        }
        return Math.max(Math.min((float)this.tps / 20.0f, 1.0f), 0.0f);
    }

    private BossBar.Color getBossBarColor() {
        if (this.isGood(PurpurConfig.commandTPSBarProgressFillMode)) {
            return PurpurConfig.commandTPSBarProgressColorGood;
        }
        if (this.isMedium(PurpurConfig.commandTPSBarProgressFillMode)) {
            return PurpurConfig.commandTPSBarProgressColorMedium;
        }
        return PurpurConfig.commandTPSBarProgressColorLow;
    }

    private boolean isGood(FillMode mode) {
        return this.isGood(mode, 0);
    }

    private boolean isGood(FillMode mode, int ping) {
        if (mode == FillMode.MSPT) {
            return this.mspt < 40.0;
        }
        if (mode == FillMode.TPS) {
            return this.tps >= 19.0;
        }
        if (mode == FillMode.PING) {
            return ping < 100;
        }
        return false;
    }

    private boolean isMedium(FillMode mode) {
        return this.isMedium(mode, 0);
    }

    private boolean isMedium(FillMode mode, int ping) {
        if (mode == FillMode.MSPT) {
            return this.mspt < 50.0;
        }
        if (mode == FillMode.TPS) {
            return this.tps >= 15.0;
        }
        if (mode == FillMode.PING) {
            return ping < 200;
        }
        return false;
    }

    private Component getTPSColor() {
        String color = this.isGood(FillMode.TPS) ? PurpurConfig.commandTPSBarTextColorGood : (this.isMedium(FillMode.TPS) ? PurpurConfig.commandTPSBarTextColorMedium : PurpurConfig.commandTPSBarTextColorLow);
        return MiniMessage.miniMessage().deserialize(color, (TagResolver)Placeholder.parsed((String)"text", (String)String.format("%.2f", this.tps)));
    }

    private Component getMSPTColor() {
        String color = this.isGood(FillMode.MSPT) ? PurpurConfig.commandTPSBarTextColorGood : (this.isMedium(FillMode.MSPT) ? PurpurConfig.commandTPSBarTextColorMedium : PurpurConfig.commandTPSBarTextColorLow);
        return MiniMessage.miniMessage().deserialize(color, (TagResolver)Placeholder.parsed((String)"text", (String)String.format("%.2f", this.mspt)));
    }

    private Component getPingColor(int ping) {
        String color = this.isGood(FillMode.PING, ping) ? PurpurConfig.commandTPSBarTextColorGood : (this.isMedium(FillMode.PING, ping) ? PurpurConfig.commandTPSBarTextColorMedium : PurpurConfig.commandTPSBarTextColorLow);
        return MiniMessage.miniMessage().deserialize(color, (TagResolver)Placeholder.parsed((String)"text", (String)String.format("%s", ping)));
    }

    public static enum FillMode {
        TPS,
        MSPT,
        PING;

    }
}

