/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.tool;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import org.purpurmc.purpur.tool.Actionable;

public class Tillable
extends Actionable {
    private final Condition condition;

    public Tillable(Condition condition, Block into, Map<Item, Double> drops) {
        super(into, drops);
        this.condition = condition;
    }

    public Condition condition() {
        return this.condition;
    }

    public static enum Condition {
        AIR_ABOVE(HoeItem::onlyIfAirAbove),
        ALWAYS(useOnContext -> true);

        private final Predicate<UseOnContext> predicate;
        private static final Map<String, Condition> BY_NAME;

        private Condition(Predicate<UseOnContext> predicate) {
            this.predicate = predicate;
        }

        public Predicate<UseOnContext> predicate() {
            return this.predicate;
        }

        public static Condition get(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        static {
            BY_NAME = new HashMap<String, Condition>();
            for (Condition condition : Condition.values()) {
                BY_NAME.put(condition.name(), condition);
            }
        }
    }
}

